% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_login.R
\name{create_graph_login}
\alias{create_graph_login}
\alias{get_graph_login}
\alias{delete_graph_login}
\alias{list_graph_logins}
\title{Login to Azure Active Directory Graph}
\usage{
create_graph_login(tenant = "common", app = .az_cli_app_id,
  password = NULL, username = NULL, auth_type = NULL,
  host = "https://graph.microsoft.com/",
  aad_host = "https://login.microsoftonline.com/", config_file = NULL,
  ...)

get_graph_login(tenant = "common", selection = NULL, refresh = TRUE)

delete_graph_login(tenant = "common", confirm = TRUE)

list_graph_logins()
}
\arguments{
\item{tenant}{The Azure Active Directory tenant for which to obtain a login client. Can be a name ("myaadtenant"), a fully qualified domain name ("myaadtenant.onmicrosoft.com" or "mycompanyname.com"), or a GUID. The default is to login via the "common" tenant, which will infer your actual tenant from your credentials.}

\item{app}{The client/app ID to use to authenticate with Azure Active Directory. The default is to login interactively using the Azure CLI cross-platform app, but you can supply your own app credentials as well.}

\item{password}{If \code{auth_type == "client_credentials"}, the app secret; if \code{auth_type == "resource_owner"}, your account password.}

\item{username}{If \code{auth_type == "resource_owner"}, your username.}

\item{auth_type}{The OAuth authentication method to use, one of "client_credentials", "authorization_code", "device_code" or "resource_owner". If \code{NULL}, this is chosen based on the presence of the \code{username} and \code{password} arguments.}

\item{host}{Your Microsoft Graph host. Defaults to \code{https://graph.microsoft.com/}. Change this if you are using a government or private cloud.}

\item{aad_host}{Azure Active Directory host for authentication. Defaults to \code{https://login.microsoftonline.com/}. Change this if you are using a government or private cloud.}

\item{config_file}{Optionally, a JSON file containing any of the arguments listed above. Arguments supplied in this file take priority over those supplied on the command line. You can also use the output from the Azure CLI \code{az ad sp create-for-rbac} command.}

\item{...}{Other arguments passed to \code{ms_graph$new()}.}

\item{selection}{For \code{get_graph_login}, if you have multiple logins for a given tenant, which one to use. This can be a number, or the input MD5 hash of the token used for the login. If not supplied, \code{get_graph_login} will print a menu and ask you to choose a login.}

\item{refresh}{For \code{get_graph_login}, whether to refresh the authentication token on loading the client.}

\item{confirm}{For \code{delete_graph_login}, whether to ask for confirmation before deleting.}
}
\value{
For \code{get_graph_login} and \code{create_graph_login}, an object of class \code{ms_graph}, representing the login client. For \code{list_graph_logins}, a (possibly nested) list of such objects.

If the AzureR data directory for saving credentials does not exist, \code{get_graph_login} will throw an error.
}
\description{
Login to Azure Active Directory Graph
}
\details{
\code{create_graph_login} creates a login client to authenticate with Microsoft Graph, using the supplied arguments. The authentication token is obtained using \link{get_azure_token}, which automatically caches and reuses tokens for subsequent sessions. Note that credentials are only cached if you allowed AzureGraph to create a data directory at package startup.

\code{get_graph_login} returns a login client by retrieving previously saved credentials. It searches for saved credentials according to the supplied tenant; if multiple logins are found, it will prompt for you to choose one.

One difference between \code{create_graph_login} and \code{get_graph_login} is the former will delete any previously saved credentials that match the arguments it was given. You can use this to force AzureGraph to remove obsolete tokens that may be lying around.
}
\section{Linux DSVM note}{

If you are using a Linux \href{https://azure.microsoft.com/en-us/services/virtual-machines/data-science-virtual-machines/}{Data Science Virtual Machine} in Azure, you may have problems running \code{create_graph_login()} (ie, without any arguments). In this case, try \code{create_graph_login(auth_type="device_code")}.
}

\examples{
\dontrun{

# without any arguments, this will create a client using your AAD credentials
az <- create_graph_login() 

# retrieve the login in subsequent sessions
az <- get_graph_login()

# this will create an Microsoft Graph client for the tenant 'microsoft.onmicrosoft.com',
# using the client_credentials method
az <- create_graph_login("microsoft", app="{app_id}", password="{password}")

# you can also login using credentials in a json file
az <- create_graph_login(config_file="~/creds.json")

}
}
\seealso{
\link{ms_graph}, \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token} for more details on authentication methods

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/overview?view=graph-rest-beta}{REST API reference}
}
