% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DR_main.R
\name{dr}
\alias{dr}
\title{Distance regression}
\usage{
dr(simi.mat, null.space, x.mat, permute = TRUE, n.MonterCarlo = 1000,
  seed = NULL)
}
\arguments{
\item{simi.mat}{a similarity matrix among the subjects.}

\item{null.space}{a numeric vector to show the column numbers of
the null space in the \code{x.mat}.}

\item{x.mat}{the covariate matrix which combines the null space
and the matrix of interest.}

\item{permute}{logical. If TRUE, the Monter Carlo sampling is used
without replacement; otherwise, with replacement. The default is
TRUE.}

\item{n.MonterCarlo}{the number of times for the Monter Carlo
procedure. The default is 1000.}

\item{seed}{if it is not NULL, set the random number generator
state for random number generation. The default is NULL.}
}
\value{
A list of \code{test.stat} and
\code{p.val}. \code{test.stat} is the observed value of the test
statistic and \code{p.val} is the p-value of the test.
}
\description{
Conduct the distance regression with or without the adjustment of
the covariates to detect the association between a distance matrix
and some independent variants of interest.
}
\details{
The pseudo \emph{F} statistic based on the distance regression with
or without the adjustment of the covariates detects the
association between a distance matrix and some independent
variants of interest. A distance matrix can be transformed into a
similarity matrix easily.
}
\examples{
data(drS.eg)
null.space <- 1
x.mat <- matrix(c(rep(1, 600), rep(0, 200)), ncol=2)
dr(drS.eg, null.space, x.mat, permute = TRUE, n.MonterCarlo = 50, seed = NULL)
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}
\references{
Q Li, S Wacholder, DJ Hunter, RN Hoover, S Chanock, G
Thomas, and K Yu. Genetic background comparison using
distance-based regression, with applications in population
stratification evaluation and adjustment. \emph{Genetic
Epidemiology}. 2009; 33(5): 432-441.

J Wessel and NJ Schork. Generalized genomic
distance-based regression methodology for multilocus association
analysis. \emph{American Journal of Human Genetics}. 2006; 79(5):
792-806.

MA Zapala and NJ Schork. Multivariate regression
analysis of distance matrices for testing associations between
gene expression patterns and related variables. \emph{Proceedings
of the National Academy of Sciences of the United States of
America}. 2006; 103(51): 19430-19435.
}

