% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitters.R
\name{uniMaxScoreSplit}
\alias{uniMaxScoreSplit}
\title{Univariate score maximizing splitting}
\usage{
uniMaxScoreSplit(bin, scorer, minExp = 5)
}
\arguments{
\item{bin}{a bin to be split with elements `x`, `y`, `depth`,
`bnds` (list with elements `x` and `y`), `expn`, `n`}

\item{scorer}{function which accepts a numeric vector of potential
split coordinates and the bounds of `bin` and returns a numeric
vector of scores for each}

\item{minExp}{numeric giving the minimum expected count allowed
in a bin}
}
\value{
A list of two bins resulting from the split of `bin` at
the maximum split location along y
}
\description{
A function which splits a bin based on the location
maximizing a score function.
}
\details{
This function is the univariate version of
`maxScoreSplit` and so is considerably simpler. It assumes the
variable to be split is named `x` in the bin, and the other
variable is to remain unsplit.
}
\author{
Chris Salahub
}
