% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBinning.R
\name{plotBinning}
\alias{plotBinning}
\title{Plot a binning using shaded rectangles}
\usage{
plotBinning(bins, fill, add = FALSE, xlab = "x", ylab = "y", ...)
}
\arguments{
\item{bins}{list of lists each with a named elements `x`, `y`, and
`bnds`, the last of which is a list having named elements `x` and
`y`}

\item{fill}{vector of values which can be interpreted as colours
of the same length as `bins`}

\item{add}{logical, should the plot of bins be added to the
current plot area?}

\item{xlab}{string, the label to be placed on the x axis}

\item{ylab}{string, the label to be placed on the y axis}

\item{...}{optional additional arguments to be passed to `plot`,
`points`}
}
\value{
A list of lists each with elements `x`, `y`, `bnds`,
`expn`, and `n`.
}
\description{
Use a binning and vector of fill
colours to visualize the sample space of pairwise data.
}
\details{
`plotBinning` plots each bin within a list of bins with
custom shading to communicate large residuals, the depth of bins,
or highlight particular bins
}
\examples{
bin <- list(x = 1:10, y = sample(1:10),
            bnds = list(x = c(0, 10), y = c(0, 10)),
            expn = 10, n = 10, depth = 0)
bin2 <- halfSplit(bin, "x")
bin3 <- unlist(lapply(bin2, maxScoreSplit, scorer = chiScores),
               recursive = FALSE)
plotBinning(bin3)
}
\author{
Chris Salahub
}
