% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssayCorrector.R
\name{correct_bias}
\alias{correct_bias}
\title{Correct the bias present in the assay, previously detected by the \code{detect_bias()} method}
\usage{
correct_bias(assay, method = NULL, alpha = 0.05, type = "PA")
}
\arguments{
\item{assay}{The assay to be corrected. Has to be an \code{assay} object.}

\item{method}{\code{NULL}:autodetect (default), \code{1}:additive, \code{2}:multiplicative}

\item{alpha}{Significance level threshold (defaults to 0.05)}

\item{type}{\code{P}:plate-specific, \code{A}:assay-specific, \code{PA}:plate then assay-specific, \code{AP}:assay then plate-specific}
}
\value{
The corrected assay (\code{assay} object)
}
\description{
\code{correct_bias()} (1) uses either of the three additive or either of the three multiplicative PMP (Partial Mean Polish) methods (the most appropriate spatial bias model can be either specified or determined by the program following the results of the Kolmogorov-Smirnov, Anderson-Darling or Cramer-von-Mises two-sample test) to correct the assay measurements if the plate-specific correction is specified; (2) carries out the assay-specific correction if specified.
}
\examples{
assay<-create_assay(m)
detected<-detect_bias(assay)
corrected<-correct_bias(detected,method=2)
}
