% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_check.set.R
\name{compare_check.set}
\alias{compare_check.set}
\title{compare_check.set}
\usage{
compare_check.set(RM_set_1, RM_set_2, DM_set_1, DM_set_2, DM_mesh_1, DM_mesh_2)
}
\arguments{
\item{RM_set_1}{matrix: 3D landmark set of the first module acquired on the reference model}

\item{RM_set_2}{matrix: 3D landmark set of the second module acquired on the reference model}

\item{DM_set_1}{matrix: 3D landmark set of the first module acquired on the disarticulated model}

\item{DM_set_2}{matrix: 3D landmark set of the second module acquired on the disarticulated model}

\item{DM_mesh_1}{mesh3d: mesh of the disarticulated model (first module)}

\item{DM_mesh_2}{mesh3d: mesh of the disarticulated model (second module)}
}
\value{
SF1 numeric: scale factor used to scale the reference set (first module)

SF2 numeric: scale factor used to scale the reference set (second module)

RM_set_1_sc matrix: scaled 3D reference set (first module)

RM_set_2_sc matrix: scaled 3D reference set (second module)

AM_model list: output of the Morpho::rotmesh.onto function

dist_from_mesh numeric: mesh distance between the aligned model and the scaled reference set

eucl_dist_1 numeric: euclidean distance between the landmark configuration of the disarticulated and reference model (first module)

eucl_dist_2 numeric: euclidean distance between the landmark configuration of the disarticulated and reference model (second module)

procr_dist numeric: procrustes distance between the landmark configuration of the aligned and reference model

procr_dist_1 numeric: procrustes distance between the landmark configuration of the disarticulated and reference model (first module)

procr_dist_2 numeric: procrustes distance between the landmark configuration of the disarticulated and reference model (second module)

eucl_dist numeric: euclidean distance between the landmark configuration of the aligned and reference model

single_l_1 numeric: euclidean distance between the landmark configuration of the disarticulated and reference model (first module)

single_l_2 numeric: euclidean distance between the landmark configuration of the disarticulated and reference model (second module)
}
\description{
This function applyes the Digital Alignment Tool (DTA) on a disarticulated model using a reference landmark configuration
}
\author{
Antonio Profico, Alessio Veneziano, Marina Melchionna, Pasquale Raia
}
