% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_amira.path.R
\name{export_amira.path}
\alias{export_amira.path}
\title{export_amira.path}
\usage{
export_amira.path(vertices, filename, Lines = c(1:(dim(vertices)[1] - 1) - 1,
  -1), path)
}
\arguments{
\item{vertices}{numeric: a kx3 matrix}

\item{filename}{character: name of the requested output}

\item{Lines}{numeric: sequence of the vertices that defines the line}

\item{path}{character: folder path}
}
\description{
Convert and save a 3D matrix into a AmiraMesh ASCII Lineset (.am) object
}
\examples{
library(Arothron)
x<-c(1:20)
y<-seq(1,3,length=20)
z<-rnorm(20,0.01)
vertices<-cbind(x,y,z)
export_amira.path(vertices=vertices,filename="example_line",path=tempdir())
}
\author{
Antonio Profico, Alessio Veneziano, Marina Melchionna, Pasquale Raia
}
