% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_layers.R
\name{argentum_list_layers}
\alias{argentum_list_layers}
\title{List Layers for a Given Organization}
\usage{
argentum_list_layers(organization)
}
\arguments{
\item{organization}{A character string specifying the name of the organization}
}
\value{
A data frame containing layer information with columns 'Name' and 'Title'
}
\description{
This function retrieves and lists the available layers for a specified organization.
}
\examples{
\donttest{
# This example uses a mock organization name.
# In a real scenario, use an actual organization name from argentum_list_organizations()
tryCatch({
  orgs <- argentum_list_organizations()
  if(nrow(orgs) > 0) {
    layers <- argentum_list_layers(orgs$Name[1])
    print(layers)
  } else {
    message("No organizations found.")
  }
}, error = function(e) {
  message("Error occurred: ", e$message)
})
}
}
