% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ArArRedux.R
\name{subset.timeresolved}
\alias{subset.logratios}
\alias{subset.redux}
\alias{subset.results}
\alias{subset.timeresolved}
\title{Select a subset of some data}
\usage{
\method{subset}{timeresolved}(x, i = NULL, labels = NULL, ...)

\method{subset}{logratios}(x, i = NULL, labels = NULL, ...)

\method{subset}{redux}(x, i = NULL, labels = NULL, ...)

\method{subset}{results}(x, i = NULL, labels = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{\link{timeresolved}},
\code{\link{logratios}}, \code{\link{redux}} or
\code{\link{results}}}

\item{i}{a vector with indices of the selected runs}

\item{labels}{a string or a vector of strings with sample names}

\item{...}{other arguments}
}
\value{
an object of the same class as \code{x}
}
\description{
Extracts those intercepts, covariances etc. that match a given list
of indices or labels.
}
\examples{
data(Melbourne)
ages <- process(Melbourne$X,Melbourne$irr,Melbourne$fract)
MD <- subset(ages,labels=c("MD2-1","MD2-2","MD2-3","MD2-4","MD2-5"))
plotcorr(MD$covmat)
}

