% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_functions.R
\name{preselselcand}
\alias{preselselcand}
\title{Preselection of selection candidates}
\usage{
preselselcand(
  gen,
  batch = 0,
  select_on = "Index",
  trait,
  Ntraits = BPdata$Ntraits,
  Nm,
  Nf,
  N,
  within_FSfam = FALSE,
  max_FSfam = "all"
)
}
\arguments{
\item{gen}{The generation of the selection candidates. A vector of generations can be provided.}

\item{batch}{The batch of the selection candidates. Default is 0. It is possible to provide a vector with multiple batches.}

\item{select_on}{Options: "Index", "EBV" or "Phenotype". For "EBV" and "Phenotype", also the trait need to be specified in 'trait'. Default is Index.}

\item{trait}{Which trait or EBV the selection is based on when option "EBV" or "Phenotype" is choosen in 'select on'.}

\item{Ntraits}{Number of simulated traits. Does not need to be specified if Ntraits is specified in a list called 'BPdata'.}

\item{Nm}{Number of males to preselect (In total or per full sib family, depending on within_FSfam).}

\item{Nf}{Number of females to preselect (In total or per full sib family, depending on within_FSfam).}

\item{N}{Total number of pre-selected fish. Does not need to be specified if Nm and Nf are specified.}

\item{within_FSfam}{If True, pre-selection takes place within a full sib family. Default is False. Only use within family selection in a family design. Each full sib family must have at least Nm male sibs and Nf female sibs (or N sibs).}

\item{max_FSfam}{Maximum number of sibs that can be selected per full sib familie, in case selection does not take place within a full sib family. Default is 'all'.}
}
\value{
This function will change the data frame called 'ped'. Fish that are not preselected will be assigned a value of 2 for ped$selcand.
}
\description{
Function to preselect selection candidates based on their Index/EBV/phenotype. Fish are preselected from the fish that are available for selection (ped$selcand==1). Fish that are not preselected will be assigned a value of 2 for ped$selcand. These fish will not be used in the function select.
}
\examples{
\donttest{ped <- founderpopfam(Nm = 60,
                     Nf = 60,
                     Nm2 = 0,
                     Nf2 = 0,
                     Ntraits = 2,
                     TraitsIndex = 2,
                     Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                     Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                     Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                     mean = c(50,500),
                     a_var = c(200,8000),
                     c_var = c(150,1000),
                     e_var = c(250,12000))
                     
Mating <- randommating(gen = 0,
                       Nfam_FS = 120)

for(fam in 1: nrow(Mating)){
ped <- offspringFSfam(gen = 1,
                      No = 100,
                      probmale = 0.5,
                      sire = Mating$Sire[fam],
                      dam = Mating$Dam[fam],
                      Ntraits = 2,
                      TraitsIndex = 2,
                      Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                      Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                      Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                      a_var = c(200,8000),
                      c_var = c(150,1000),
                      e_var = c(250,12000))
}

ped <- preselphen(gen = 1,
                  Nenv = 2,
                  Npresel = c(25,15),
                  trait = 1,
                  Ntraits = 2)
                  
ped <- avail_selection(gen = 1,
                       presel = 1,
                       surv = 0.9)
                       
ped <- breeding_values(gen = 1,
                       TraitsIndex = 2,
                       EBV = "GEBV",
                       GenomLength = 11.3,
                       Ne = 100,
                       SizeTraining = nrow(ped[ped$preselected ==2,]),
                       Ntraits = 2,
                       a_var = c(200,8000),
                       h2 = c(0.33,0.38))
                       
ped <- preselselcand(gen = 1,
                 Nm = 300,
                 Nf = 300,
                 max_FSfam = 15,
                 Ntraits = 2)
}
}
