% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntManAPI.R
\name{AM_unibin_mix_hyperparams}
\alias{AM_unibin_mix_hyperparams}
\title{Univariate Binomial Mixture Hyperparameters.

Generate a configuration object that specifies the prior hyperparameters for a mixture of  Univariate Binomial kernels wth probability of success \eqn{\tau} and size \eqn{N}.
The conjugate prior on \eqn{\tau} is a Beta distribution:
\deqn{ \pi(\tau\mid \alpha,\beta)=\frac{\Gamma(\alpha+\beta)}{\Gamma(\alpha)\Gamma(\beta)} \tau^{\alpha-1}\left( 1-\tau \right)^{\beta-1} , \qquad 0\le\tau\le1}
\eqn{N} is fixed by the user and should always be specified. Here,
\eqn{\alpha} corresponds to \code{a0},\eqn{\beta} to \code{b0}.
The default for the prior hyperparameters is \eqn{a0=1, b0=1}.}
\usage{
AM_unibin_mix_hyperparams(a0, b0, N)
}
\arguments{
\item{a0}{The a0 hyperparameter.}

\item{b0}{The b0 hyperparameter.}

\item{N}{size of the Binomial distribution.}
}
\value{
A list to be used as \code{mix_kernel_hyperparams} argument for \code{mcmc_fit}.
}
\description{
Univariate Binomial Mixture Hyperparameters.

Generate a configuration object that specifies the prior hyperparameters for a mixture of  Univariate Binomial kernels wth probability of success \eqn{\tau} and size \eqn{N}.
The conjugate prior on \eqn{\tau} is a Beta distribution:
\deqn{ \pi(\tau\mid \alpha,\beta)=\frac{\Gamma(\alpha+\beta)}{\Gamma(\alpha)\Gamma(\beta)} \tau^{\alpha-1}\left( 1-\tau \right)^{\beta-1} , \qquad 0\le\tau\le1}
\eqn{N} is fixed by the user and should always be specified. Here,
\eqn{\alpha} corresponds to \code{a0},\eqn{\beta} to \code{b0}.
The default for the prior hyperparameters is \eqn{a0=1, b0=1}.
}
\examples{
AM_unibin_mix_hyperparams (a0=1,b0=1,N=100)
}
