% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadingSaving.R
\name{loadAndromeda}
\alias{loadAndromeda}
\title{Load Andromeda from file}
\usage{
loadAndromeda(fileName, options = list())
}
\arguments{
\item{fileName}{The path where the object was saved using \code{\link[=saveAndromeda]{saveAndromeda()}}.}

\item{options}{A list containing Andromeda options. Currently the only supported option is 'threads'.
Setting \code{options = list(threads = 10)} will set the database used by Andromeda to use 10 threads.}
}
\value{
An \code{\link{Andromeda}} object.
}
\description{
Load Andromeda from file
}
\examples{
# For this example we create an Andromeda object and save it to
# a temporary file locationL
fileName <- tempfile()
andr <- andromeda(cars = cars)
saveAndromeda(andr, fileName)

# Using loadAndromeda to load the object back:
andr <- loadAndromeda(fileName)

# Don't forget to close Andromeda when you are done:
close(andr)

# Cleaning up the file used in this example:
unlink(fileName)

}
\seealso{
\code{\link[=saveAndromeda]{saveAndromeda()}}
}
