% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotAMids.R
\name{plotAMids}
\alias{plotAMids}
\title{plotAMids}
\usage{
plotAMids(AMids, phenoFile = "", columnPlot = "I", quantilePlot = "yes",
  colorPlot = "BlBrewer", sepLinesPop = "yes", sepLineRef = "yes",
  plotIndNames = "no", legColor = "yes", legRef = "yes",
  legPheno = "yes", legAxisPop = "yes")
}
\arguments{
\item{AMids}{Dataframe of genetic distances calculated by calculateAMids.}

\item{phenoFile}{Optional file with phenotype information for each individual. Columns should be named 'UNIQID' 'Pheno_1' 'Colors_1' and 'Order'. If provided each individual is assigned a color code that labels with individuals. If "Colors_" are not provided the function will randomly assign colors to each phenotype. Three different phenotypes are possible, in order of size: e.g., Pheno_1 could be population, Pheno_2 Continental Region, Pheno_3 the dataset. Order is used to order the individuals in the plot.}

\item{columnPlot}{Takes values 'I' or 'C'. 'I' is the default option. 'I' plots the normalised euclidean distances whereas 'C' plots the crude distances.}

\item{quantilePlot}{Takes values 'yes' or 'no'. 'yes' is the default option. If columnPlot is 'C', 'yes' will plot the quantiles, 'no' will plot the raw values}

\item{colorPlot}{Colors for the AMids. Possible choices are 'RedBl', 'RedBlGr' and 'BLBrewer'. The user can also provide a vector of colors.}

\item{sepLinesPop}{Takes values 'yes' or 'no'. The default is 'yes'. If 'yes', a line demarcating populations is plotted.}

\item{sepLineRef}{Takes values 'yes' or 'no'. The default is 'yes'. If 'yes', a line demarcating continental regions for the HGDP populations is plotted.}

\item{plotIndNames}{Takes values 'yes' or 'no'. The default is 'yes'. If 'yes', the legend colour will be plotted in the top left.}

\item{legColor}{Takes values 'yes' or 'no'. The default is 'yes'. If 'yes', the legend colour will be plotted in the top left.}

\item{legRef}{Takes values 'yes' or 'no'. The default is 'yes'. If 'yes', indications of continental region will be plotted.}

\item{legPheno}{Takes values 'yes' or 'no'. The default is 'yes'. If phenoFile is given, colors corresponding to the labels in phenoFile are plotted on the right handside of the plot.}

\item{legAxisPop}{Takes values 'yes' or 'no'. The default is 'yes'. If 'yes' and phenotype information is provided, this will be plotted on the right axis of the plot.}
}
\value{
Return a plot of the relationship of a sample population to the HGDP references to the R plotting device.
}
\description{
\code{plotAMids} visualizes genetic distances as calculated by \code{calculateAMids}.
}
\details{
\code{plotAMids} is used to visualise the relationship amongst individuals and the population references.
}
\examples{
\dontrun{
library(AncestryMapper)
HGDP.References <- system.file('extdata', 'HGDP.References.txt', package='AncestryMapper')
HGDP.500SNPs <- system.file('extdata', 'HGDP.500SNPs.ped', package='AncestryMapper')
HGDP.Phenotypes <- system.file('extdata', 'HGDP.Phenotypes.txt', package='AncestryMapper')
genetic.distance <- calculateAMids(pedtxtFile=HGDP.500SNPs, fileReferences=HGDP.References)
plotAMids(AMids=genetic.distance, phenoFile=HGDP.Phenotypes)
}
}

