% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HolmTest.R
\name{HolmTest}
\alias{HolmTest}
\title{Holm-Adjusted Pairwise Comparisons v2.0}
\usage{
HolmTest(modelo, comparar = NULL, alpha = 0.05)
}
\arguments{
\item{modelo}{An \code{aov} or \code{lm} object (full model: includes blocks, factors, etc.).}

\item{comparar}{Character vector with the name(s) of the factor(s) to compare:
- One name: main effect (e.g., "treatment" or "A")
- Several names: interaction (e.g., \code{c("A","B")} for \code{A:B})
If omitted, it uses the first factor in \code{modelo$xlevels}.}

\item{alpha}{Significance level (default 0.05).}
}
\value{
An object of class \code{"holm"} and \code{"comparaciones"} containing:
\itemize{
  \item \code{Resultados}: a data.frame with columns \code{Comparacion}, \code{Diferencia}, \code{SE}, \code{t_value},
        \code{p_value} (unadjusted), \code{p_ajustada} (Holm), \code{Valor_Critico} (critical difference), and \code{Significancia}.
  \item \code{Promedios}: a named vector of group means as defined by \code{comparar}.
  \item \code{Orden_Medias}: group names ordered from highest to lowest mean.
  \item \code{Metodo}: "Holm t-test".
  \item \code{Termino}: the term being compared (e.g., "A", "B", or "A:B").
  \item \code{MSerror}, \code{df_error}, \code{N}: useful for plots with error bars.
}
}
\description{
Performs pairwise t-tests with p-values adjusted using Holm’s sequential method.
}
\details{
Advantages:
- Controls family-wise error rate more efficiently than Bonferroni.
- Easy to apply over any set of p-values.

Disadvantages:
- Does not adjust test statistics, only p-values.
- Slightly more conservative than false discovery rate (FDR) methods.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- HolmTest(mod)
summary(resultado)
plot(resultado)

# RCBD
mod <- aov(Sueldo_actual ~ as.factor(labor) + Sexo, data = d_e)
res <- HolmTest(mod, comparar = "as.factor(labor)")
summary(res); plot(res)                # usa p_ajustada automaticamente

# Factorial
mod2 <- aov(Sueldo_actual ~ as.factor(labor) * Sexo, data = d_e)
resAB <- HolmTest(mod2, comparar = c("as.factor(labor)","Sexo"))
summary(resAB, n = Inf); plot(resAB, horizontal = TRUE)

}
\references{
Holm, S. (1979). A simple sequentially rejective multiple test procedure.Scandinavian Journal of Statistics, 6(2), 65–70.
}
