% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\name{resetPop}
\alias{resetPop}
\title{Reset population}
\usage{
resetPop(pop, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
an object of \code{\link{Pop-class}}
}
\description{
Recalculates a population's genetic values and 
resets phenotypes and EBVs.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Rescale to set mean to 1
SP$rescaleTraits(pop,mean=1)
pop = resetPop(pop, simParam=SP)

}
