% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadraticplateau_analysis.R
\name{quadratic.plateau}
\alias{quadratic.plateau}
\title{Analysis: Quadratic-plateau}
\usage{
quadratic.plateau(
  trat,
  resp,
  sample.curve = 1000,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  error = "SE",
  r2 = "all",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  linetype = 1,
  pointshape = 21,
  fillshape = "gray",
  colorline = "black",
  round = NA,
  yname.formula = "y",
  xname.formula = "x",
  comment = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{sample.curve}{Provide the number of observations to simulate curvature (default is 1000)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{linetype}{line type}

\item{pointshape}{format point (default is 21)}

\item{fillshape}{Fill shape}

\item{colorline}{Color lines}

\item{round}{round equation}

\item{yname.formula}{Name of y in the equation}

\item{xname.formula}{Name of x in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs the quadratic-plateau regression analysis.
}
\details{
The quadratic-plateau model is defined by:

First curve:
\deqn{y = \beta_0 + \beta_1 \cdot x + \beta_2 \cdot x^2 (x < breakpoint)}

Second curve:
\deqn{y = \beta_0 + \beta_1 \cdot breakpoint + \beta_2 \cdot breakpoint^2 (x > breakpoint)}
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
quadratic.plateau(time,WL)
}
\references{
Chiu, G. S., R. Lockhart, and R. Routledge. 2006. Bent-cable regression theory and applications. Journal of the American Statistical Association 101:542-553.

Toms, J. D., and M. L. Lesperance. 2003. Piecewise regression: a tool for identifying ecological thresholds. Ecology 84:2034-2041.
}
\seealso{
\link{linear.linear}, \link{linear.plateau}
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
