% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tonetest.R
\name{plot_tonetest}
\alias{plot_tonetest}
\title{Graphics: Graphic for t test to compare means with a reference value}
\usage{
plot_tonetest(tonetest, alpha = 0.95)
}
\arguments{
\item{tonetest}{t.one.test object}

\item{alpha}{confidence level.}
}
\value{
returns a density plot and a column plot to compare a reference value with other treatments.
}
\description{
Sometimes the researcher wants to test whether the treatment mean is greater than/equal to or less than a reference value. For example, I want to know if the average productivity of my treatment is higher than the average productivity of a given country. For this, this function allows comparing the means with a reference value using the t test.
}
\examples{
library(AgroR)
data("pomegranate")
resu=tonetest(resp=pomegranate$WL, trat=pomegranate$trat, mu=2)
plot_tonetest(resu)
}
\author{
Gabriel Danilo Shimizu
}
