% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transf_function.R
\name{transf}
\alias{transf}
\title{Utils: Data transformation (Box-Cox, 1964)}
\usage{
transf(response, f1, f2 = NA, f3 = NA, block = NA, line = NA, column = NA)
}
\arguments{
\item{response}{Numerical vector containing the response of the experiment.}

\item{f1}{Numeric or complex vector with factor 1 levels}

\item{f2}{Numeric or complex vector with factor 2 levels}

\item{f3}{Numeric or complex vector with factor 3 levels}

\item{block}{Numerical or complex vector with blocks}

\item{line}{Numerical or complex vector with lines}

\item{column}{Numerical or complex vector with columns}
}
\value{
Returns the value of lambda and/or data transformation approximation, according to Box-Cox (1964)
}
\description{
Estimates the lambda value for data transformation
}
\examples{
data("pomegranate")
with(pomegranate, transf(WL,trat))
}
\references{
Box, G. E., Cox, D. R. (1964). An analysis of transformations. Journal of the Royal Statistical Society: Series B (Methodological), 26(2), 211-243.
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Experimental}
\keyword{Transformation}
