% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_function.R
\name{cover_special_periods}
\alias{cover_special_periods}
\title{Cover special periods.}
\usage{
cover_special_periods(
  events.data,
  special.periods.data,
  ID.colname,
  medication.class.colnames,
  disp.date.colname,
  disp.start.colname,
  episode.start.colname,
  episode.end.colname,
  duration.colname,
  days.before,
  days.after,
  date.format,
  suppress.warnings = FALSE,
  return.data.table = FALSE,
  ...
)
}
\arguments{
\item{events.data}{A \emph{\code{data.frame}} or \emph{\code{data.table}} with the event durations.}

\item{special.periods.data}{a \emph{\code{data.frame}} or or \emph{\code{data.table}}
containing the information about special periods (e.g., hospitalizations or other situations
where medication use may differ, e.g. during incarcerations or holidays). Must contain the same unique
patient ID as dispensing and prescription data, the start and end dates of the special
periods with the exact column names \emph{\code{DATE.IN}} and \emph{\code{DATE.OUT}}.}

\item{ID.colname}{A \emph{string}, the name of the column in \code{events.data} and
\code{special.periods.data} containing the unique patient ID.}

\item{medication.class.colnames}{A \emph{\code{Vector}} of \emph{strings}, the
name(s) of the column(s) in the \code{events.data} identify medication classes.}

\item{disp.date.colname}{A \emph{string}, the name of the column in
\code{events.data} containing the dispensation start date (in the format given in
the \code{date.format} parameter).}

\item{disp.start.colname, episode.start.colname, episode.end.colname}{column names in
\code{events.data}.}

\item{duration.colname}{A \emph{string}, the name of the column in
\code{events.data} containing the duration of the medication event.}

\item{days.before}{an \emph{integer}, the number of days before the start of a special period
within which an event duration must end to consider the special period as covered.}

\item{days.after}{an \emph{integer}, the number of days after a special period within
which an event duration must start to consider the special period as covered.}

\item{date.format}{A \emph{string} giving the format of the dates used in
the \code{data} and the other parameters; see the \code{format} parameters
of the \code{\link[base]{as.Date}} function for details (NB, this concerns
only the dates given as strings and not as \code{Date} objects).}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}

\item{return.data.table}{\emph{Logical}, if \code{TRUE} return a
\code{data.table} object, otherwise a \code{data.frame}.}

\item{...}{other possible parameters.}
}
\value{
A \code{data.frame} or \code{data.table}, the \code{events.data} with the additional
durations for special periods covered.
}
\description{
Identifies special periods that are in proximity to already covered durations and adds additional
events for these durations.
}
\details{
Special periods may appear as gaps, possibly leading to underestimation of implementation or even
assumption of discontinuation and non-persistence. To consider such periods as covered, this function
adds additional durations, for example when it is assumed that hospitalized patients are adherent
during the hospitalization period. This function should be used after pruning with
\code{prune_event_durations}.
}
\examples{
\dontrun{
# select medication class of interest and compute event durations
disp_data <- durcomp.dispensing[ID == 3 & grepl("J01EE01", ATC.CODE)]
presc_data <- durcomp.prescribing[ID == 3 & grepl("J01EE01", ATC.CODE)]

event_durations_list <- compute_event_durations(disp.data = disp_data,
                                                presc.data = presc_data,
                                                special.periods.data = durcomp.hospitalisation,
                                                special.periods.method = "carryover",
                                                ID.colname = "ID",
                                                presc.date.colname = "DATE.PRESC",
                                                disp.date.colname = "DATE.DISP",
                                                date.format = "\%Y-\%m-\%d",
                                                medication.class.colnames = c("ATC.CODE",
                                                                              "UNIT",
                                                                              "FORM"),
                                                total.dose.colname = "TOTAL.DOSE",
                                                presc.daily.dose.colname = "DAILY.DOSE",
                                                presc.duration.colname = "PRESC.DURATION",
                                                visit.colname = "VISIT",
                                                force.init.presc = TRUE,
                                                force.presc.renew = TRUE,
                                                split.on.dosage.change = TRUE,
                                                trt.interruption = "carryover",
                                                suppress.warnings = FALSE,
                                                return.data.table = TRUE,
                                                progress.bar = FALSE)

event_durations <- prune_event_durations(event_durations_list,
                                         include = c("special periods"),
                                         medication.class.colnames = "ATC.CODE",
                                         days.within.out.date.1 = 7,
                                         days.within.out.date.2 = 30,
                                         keep.all = TRUE)

# cover special periods
special_periods <- event_durations_list$special_periods
event_durations_covered <- cover_special_periods(events.data = event_durations,
                                                 special.periods.data = special_periods,
                                                 ID.colname = "ID",
                                                 medication.class.colnames = "ATC.CODE",
                                                 disp.start.colname = "DISP.START",
                                                 duration.colname = "DURATION",
                                                 days.before = 7,
                                                 days.after = 7,
                                                 date.format = "\%Y-\%m-\%d")
       }
}
