% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{plot_interactive_cma}
\alias{plot_interactive_cma}
\title{Interactive exploration CMA computation.}
\usage{
plot_interactive_cma(data = NULL, ID = NULL, cma.class = c("simple",
  "per episode", "sliding window")[1], print.full.params = FALSE,
  ID.colname = NA, event.date.colname = NA, event.duration.colname = NA,
  event.daily.dose.colname = NA, medication.class.colname = NA,
  date.format = NA, followup.window.start.max = 5 * 365,
  followup.window.duration.max = 5 * 365,
  observation.window.start.max = followup.window.start.max,
  observation.window.duration.max = followup.window.duration.max,
  maximum.permissible.gap.max = 2 * 365,
  sliding.window.start.max = followup.window.start.max,
  sliding.window.duration.max = 2 * 365,
  sliding.window.step.duration.max = 2 * 365)
}
\arguments{
\item{data}{A \emph{\code{data.frame}} containing the events (prescribing or
dispensing) used to compute the CMA. Must contain, at a minimum, the patient
unique ID, the event date and duration, and might also contain the daily
dosage and medication type (the actual column names are defined in the
following four parameters).}

\item{ID}{The ID (as given in the \code{ID.colname} column) of the patient
whose data to interactively plot (if absent, pick the first one); please not
that this an be interactively selected during plotting.}

\item{cma.class}{The type of CMAs to plot; can be "simple" (CMA0 to CMA9),
"per episode", or "sliding window".}

\item{print.full.params}{A \emph{logical} specifying if the values of all the
parameters used to generate the current plot should be printed in the console
(if \emph{TRUE}, it can generate extremely verbose output!).}

\item{ID.colname}{A \emph{string}, the name of the column in \code{data}
containing the unique patient ID, or \code{NA} if not defined.}

\item{event.date.colname}{A \emph{string}, the name of the column in
\code{data} containing the start date of the event (in the format given in
the \code{date.format} parameter), or \code{NA} if not defined.}

\item{event.duration.colname}{A \emph{string}, the name of the column in
\code{data} containing the event duration (in days), or \code{NA} if not
defined.}

\item{event.daily.dose.colname}{A \emph{string}, the name of the column in
\code{data} containing the prescribed daily dose, or \code{NA} if not defined.}

\item{medication.class.colname}{A \emph{string}, the name of the column in
\code{data} containing the classes/types/groups of medication, or \code{NA}
if not defined.}

\item{date.format}{A \emph{string} giving the format of the dates used in the
\code{data} and the other parameters; see the \code{format} parameters of the
\code{\link[base]{as.Date}} function for details (NB, this concerns only the
dates given as strings and not as \code{Date} objects).}

\item{followup.window.start.max}{The maximum number of days when the
follow-up window can start.}

\item{followup.window.duration.max}{The maximum duration of the follow-up
window in days.}

\item{observation.window.start.max}{The maximum number of days when the
observation window can start.}

\item{observation.window.duration.max}{The maximum duration of the
observation window in days.}

\item{maximum.permissible.gap.max}{The maximum permissible gap in days.}

\item{sliding.window.start.max}{The maximum number of days when the sliding
windows can start.}

\item{sliding.window.duration.max}{The maximum duration of the sliding
windows in days.}

\item{sliding.window.step.duration.max}{The maximum sliding window step in
days.}
}
\value{
Nothing
}
\description{
Interactively plot a given patient's data, allowing the real-time exploration
of the various CMAs and their parameters.
It is not intended for heavy use but simply for the exploration of various
parameters and ways of computing the CMA. The interface is constrained by the
current limitations of the \code{manipulate} library.
}
\details{
This function must be run within \code{RStudio} (as it uses the
\code{manipulate} library), and it allows the interactive manipulation of
various parameters and ways of computing the CMA for a participant's event
data.
Please note that:
\itemize{
  \item the graphical interface may allow the user to change certain
  parameters (such as considering carry over) even in the case of simple CMAs
  that do not consider these parameters (such as CMA1 for carry over) -- in
  this case changing these parameters has no effect;
  \item for CMA-per-episode only, additional parameters can be accessed in
  the interface regarding permissible gap length (days or percent) and
  whether medication changes indicate new episodes
  \item for sliding-window-CMA only, additional parameters can be accessed
  in the interface regarding the sliding window start, duration and step.
}
}
\examples{
\dontrun{
plot.interactive.cma(med.events);}
}
