% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repertoireFastas.R
\name{repertoireFastas}
\alias{repertoireFastas}
\title{Converts AbSim's output sequences and names into fasta file format. Each tree
within the repertire will be stored in an individual fasta file. Utilizes
sink() and cloneAllConnections() from R base}
\usage{
repertoireFastas(ab.repertoire, fasta.name, with.germline)
}
\arguments{
\item{ab.repertoire}{The output from the either the singleLineage function or
the fullRepertoire function. This takes should be a nested list, with the first
element containing a list of sequence arrays, the second element containing the
corresponding list of names, and the third element containing a list of trees.
The following list elements (containing the sampling information) will be
disregarded for repertoire expansion.}

\item{fasta.name}{The name of the fasta files. Each tree will be numbered
corresponding to the index within the ab.repertoire list. For example,
the second tree in an ab.repertoire object will be "fasta.name_2.fasta",}

\item{with.germline}{Logical value specifying if the germline sequences
should be included in the fasta file (as the first sequence)}
}
\description{
Converts AbSim's output sequences and names into fasta file format. Each tree
within the repertire will be stored in an individual fasta file. Utilizes
sink() and cloneAllConnections() from R base
}
\examples{
\dontrun{
repertoireFastas(ab.repertoire=ab.repertoire.output,
 fasta.name="sample_trees",
 with.germline=TRUE
}
}

