% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena.R
\docType{methods}
\name{Athena}
\alias{Athena}
\alias{dbConnect,AthenaDriver-method}
\title{Athena DBI wrapper}
\usage{
Athena()

\S4method{dbConnect}{AthenaDriver}(drv, region, s3_staging_dir, schema_name,
  ...)
}
\arguments{
\item{drv}{An object created by \code{Athena()}}

\item{region}{the AWS region}

\item{s3_staging_dir}{S3 bucket where results will be saved to}

\item{schema_name}{Athena schema to use}

\item{...}{Other options}
}
\description{
Athena DBI wrapper

Authentication credentials are read from the DefaultAWSCredentialsProviderChain, which includes the .aws folder and
environment variables.
}
\examples{
\dontrun{
require(DBI)
con <- dbConnect(AWR.Athena::Athena(), region='us-west-2', 
                 s3_staging_dir='s3://nfultz-athena-staging', 
                 schema_name='default')
dbListTables(con)
dbGetQuery(con, "Select count(*) from sampledb.elb_logs")
}
}
\seealso{
\href{http://docs.aws.amazon.com/athena/latest/ug/connect-with-jdbc.html#jdbc-options}{Athena Manual} for more connections options.
}
