% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_odeweb.R
\name{plot_odeweb}
\alias{plot_odeweb}
\title{Plot food web dynamics}
\usage{
plot_odeweb(x, nb_s)
}
\arguments{
\item{x}{matrix with solutions. First row should be the time vector.}

\item{nb_s}{numeric, number of species as in the model (e.g.,
\code{create_model_Unscaled_nuts}).}
}
\value{
No return value, called for side effects.
}
\description{
Plot solution of the ODE for the food web. Currently only
  species and not nutrients are plotted.
}
\examples{
\dontrun{
library(ATNr)
library(deSolve)
set.seed(123)
# number of species, nutrients, and body masses
n_species <- 20
n_basal <- 5
n_nutrients <- 3
masses <- sort(10^runif(n_species, 2, 6)) #body mass of species
# create food web matrix
L <- create_Lmatrix(masses, n_basal)
L[, 1:n_basal] <- 0
fw <- L
fw[fw > 0] <- 1
model <- create_model_Unscaled_nuts(
  n_species,
  n_basal,
  n_nutrients,
  masses,
  fw
)
# initialize model as default in Schneider et al. (2016)
model <- initialise_default_Unscaled_nuts(model, L)
# defining integration time
times <- seq(0, 500, 5)
biomasses <- runif(n_species + n_nutrients, 2, 3)
sol <- lsoda_wrapper(times, biomasses, model, verbose = FALSE)
plot_odeweb(sol, model$nb_s)
}
}
