% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentinel2_msi.R
\name{sen2_msi}
\alias{sen2_msi}
\title{Make your own custom Sentinel-2 MSI satellite image products}
\usage{
sen2_msi(directory = getwd(), cus.formula = "none", crop = "n",
  ext2crop = "none")
}
\arguments{
\item{cus.formula}{Assign custom formula to be computed AS TEXT input (inside double quotes).
To assign bands, ONLY USE BAND NUMBERS (b1, b2,....,b12) to indicate different bands in the formula.}

\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
Computed Sentinel 2 custom product
}
\description{
This function is dedicated to Sentinel-2 MSI satellite image processing. Provide your custom equation to
produce the desired results (Tested only Sentinel 2 L1C products).
}
\note{
1. FILENAMES OF ANY BAND FILES (*.jp2 files) SHOULDN'T CHANGED.

2. Bands with same resolution can only be computed.

2. Windows users should be careful while assigning directory. Use "/" to seperate folders not "\\".
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
##path <- system.file ("TM_sample", package = "ASIP")
# Input equation should be as text (inside double quotes)
eqn <- "((2 * b4)+ (b3+pi+b8))/(b3+b4+b8)"
##shapefil <- paste0 (path, "/test.shp")
##op <- custom.eqn (directory = path, cus.formula = eqn, crop = "y", ext2crop = shapefil)
}
