% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ARPA_Lombardia_AQ_data.R
\name{get_ARPA_Lombardia_AQ_data}
\alias{get_ARPA_Lombardia_AQ_data}
\title{Download air quality data from ARPA Lombardia website}
\usage{
get_ARPA_Lombardia_AQ_data(
  ID_station = NULL,
  Year = 2022,
  Frequency = "hourly",
  Var_vec = NULL,
  Fns_vec = NULL,
  by_sensor = F,
  parallel = T,
  verbose = T
)
}
\arguments{
\item{ID_station}{Numeric value. ID of the station to consider. Using ID_station = NULL, all the available
stations are selected. Default is ID_station = NULL.}

\item{Year}{Numeric vector. Year(s) of interest. Default is Year = 2020. Specifying more than one year the
code works in parallel computing (half of the available cores) using parLapply() function.}

\item{Frequency}{Temporal aggregation frequency. It can be "hourly", "daily", "weekly", "monthly" or "yearly".
Default is Frequency = "hourly".}

\item{Var_vec}{Character vector of variables to aggregate. If NULL (default) all the variables are averaged.}

\item{Fns_vec}{Character vector of aggregation function to apply to the selected variables.
Available functions are mean, median, min, max, sum, qPP (PP-th percentile), sd, var,
vc (variability coefficient), skew (skewness) and kurt (kurtosis).}

\item{by_sensor}{Logic value (T or F). If 'by_sensor=T', the function returns the observed concentrations
by sensor code, while if 'by_sensor=F' (default) it returns the observed concentrations by station.}

\item{parallel}{Logic value (T or F). If 'parallel=T' (default), data downloading is performed using parallel computing
(socketing), while if 'parallel=F' (default) the download is performed serially. 'parallel=T' works only when
'Year' is a vector with multiple values, i.e. for a single year the serial computing is performed.}

\item{verbose}{Logic value (T or F). Toggle warnings and messages. If 'verbose=T' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose=F' any message about
the progression is suppressed.}
}
\value{
A data frame of class 'data.frame' and 'ARPALdf'. The object is fully compatible with Tidyverse.
}
\description{
'get_ARPA_Lombardia_AQ_data' returns observed air quality measurements collected by
ARPA Lombardia ground detection system for Lombardy region in Northern Italy.
Available airborne pollutant concentrations are: NO2, NOx, PM10, PM2.5, Ozone, Arsenic, Benzene,
Benzo-a-pirene, Ammonia, Sulfur Dioxide, Black Carbon, CO, Nikel, Cadmium and Lead.
Data are available from 1996 and are updated up to the current date.
For more information about the municipal data visit the section 'Monitoraggio aria' at the webpage:
https://www.dati.lombardia.it/stories/s/auv9-c2sj
}
\examples{
\donttest{
## Download hourly air quality data for 2023 at station 501.
get_ARPA_Lombardia_AQ_data(ID_station=501,Year=2023,Frequency="hourly",by_sensor = 0)
## Download monthly data for NOx and NO2 observed during 2021 for all the stations
## active on the network. For NOx is computed the 25th percentile, while for NO2 is
## computed the maximum concentration observed.
get_ARPA_Lombardia_AQ_data(ID_station=NULL,Year=2021,Frequency="monthly",
   Var_vec=c("NOx","NO2"),Fns_vec=c("q25","max"),by_sensor = 0)
## Download hourly air quality data by sensor for 2022 at station 501.
get_ARPA_Lombardia_AQ_data(ID_station=501,Year=2022,by_sensor = TRUE)
}

}
