% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.double.focal.R
\name{perm.double.focal}
\alias{perm.double.focal}
\title{Data stream permutation for focal sampling data .}
\usage{
perm.double.focal(
  obs,
  ego,
  alters,
  focal,
  nperm,
  progress = FALSE,
  index = "sri",
  measure,
  test = "median",
  df = NULL,
  dfid = NULL,
  rf,
  ...
)
}
\arguments{
\item{obs}{a data frame of focal observations.}

\item{ego}{an integer indicating the column of the focal id for the obs.}

\item{alters}{an integer indicating the column of focal's alters in obs.}

\item{focal}{a numeric vector indicating the focal number in obs.}

\item{nperm}{an integer indicating the number of permutations to performed.}

\item{progress}{a boolean indicating if the permutation process must be visible.}

\item{index}{Which type of index of associations to calculate:
\itemize{
\item 'sri' for Simple ratio index: \eqn{x \div x+yAB+yA+yB}
\item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}

\item{measure}{a character indicating the social network measure to compute (Only those available in ANTs)}

\item{test}{a character indicating the test to realize to account for the social network measure}

\item{df}{a data frame of individual characteristics in which store permutations.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}

\item{rf}{an integer (column id) or a string (column name) indicating the column holding the factor grouping multiple networks in argument \emph{df}.}

\item{...}{Additional arguments related to the social network measure to compute (argument measure).}
}
\description{
Warning, the original function (Farine 2017) uses a control factor, the number of focals and the ids of the focals.
}
\details{
Pre-network permutation for focal sampling data, and for symmetric behaviour only.
}
\examples{
# Single network without data frame---------------------
head(sim.focal.undirected)
t=perm.double.focal(obs = sim.focal.undirected, ego = 3, alters = 4, 
focal = 1, nperm = 10, progress = FALSE, measure = "met.strength")
# Multiple networks with data frames---------------------
d1 = data.frame("id" = names(t[[1]]), "period" = 1)
d2 = data.frame("id" = names(t[[1]]), "period" = 2)
t = list(d1, d2)
obs = list(sim.focal.undirected, sim.focal.undirected)
t =perm.double.focal(obs = obs, ego = 3, alters = 4, focal = 1, nperm = 10, 
measure = "met.strength",  df = t, dfid = "id", rf = "period")
}
\references{
Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in ecology and evolution, 8(10), 1309-1320.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
