# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

metric_global_shortestPath <- function(disMap) {
    .Call(`_ANTs_metric_global_shortestPath`, disMap)
}

metric_global_shortestDetails <- function(disMap) {
    .Call(`_ANTs_metric_global_shortestDetails`, disMap)
}

metric_node_betweeness <- function(disMap) {
    .Call(`_ANTs_metric_node_betweeness`, disMap)
}

metric_global_triangle <- function(disMap) {
    .Call(`_ANTs_metric_global_triangle`, disMap)
}

#' @title Association indexes
#' @description Individual associations indexes.
#' @param Mfbi a group by individual matrix.
#' @param method a string indicating the type of association matrix:
#' \itemize{
#' \item 'sri' for Simple ratio index: \eqn{x/x+yAB+yA+yB}
#' \item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
#' \item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
#' }
#' @return A square matrix of association according to association index choose:
#' @details Association indexes allow to handle  heterogeneity of time of observation. 
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
assoc_mat <- function(Mgbi, method, return_denom = FALSE) {
    .Call(`_ANTs_assoc_mat`, Mgbi, method, return_denom)
}

#' @title Association indexes
#' @description Individual associations indexes.
#' @param Mfbi a group by individual matrix.
#' @param method a string indicating the type of association matrix:
#' \itemize{
#' \item 'sri' for Simple ratio index: \eqn{x/x+yAB+yA+yB}
#' \item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
#' \item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
#' }
#' @return A square matrix of association according to association index choose:
#' @details Association indexes allow to handle  heterogeneity of time of observation. 
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
assoc_mat_full <- function(Mgbi, method) {
    .Call(`_ANTs_assoc_mat_full`, Mgbi, method)
}

#' @title Association indexes for one individual
#' @description Individual associations indexes.
#' @param Mfbi a group by individual matrix.
#' @param id an integer indicating the column (c++ refering) of the individual to which compute the association index.
#' @param method a string indicating the type of association matrix:
#' \itemize{
#' \item 'sri' for Simple ratio index: \eqn{x/x+yAB+yA+yB}
#' \item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
#' \item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
#' }
#' @return A square matrix of association according to association index choose:
#' @details Association indexes allow to handle  heterogeneity of time of observation. 
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
assoc_mat_one_id <- function(Mgbi, id, method) {
    .Call(`_ANTs_assoc_mat_one_id`, Mgbi, id, method)
}

#' @title Merge two data frames
#' @description Merge two data frames keeping the structure of the first one
#' @keywords internal
df_merge <- function(df1, df2) {
    .Call(`_ANTs_df_merge`, df1, df2)
}

#' @title Group by individual matrix.
#' @description Convert a data frame into a group by individual matrix. 
#' @param d a data frame.
#' @param col_scan an integer indicating the column number holding the information of the scans.
#' @param col_id an integer indicating the column number holding the individuals observations.
#' @param uIds a character vector holding all the ids of the individuals.
#' @param uScans a character vector holding all the ids of the scans. 
#' @return A group by individual matrix.
#' @author Sebastian Sosa, Ivan Puga-Gonzales
#' @keywords internal
df_to_gbi <- function(d, col_scan, col_id, uIds, uScans) {
    .Call(`_ANTs_df_to_gbi`, d, col_scan, col_id, uIds, uScans)
}

#' @title Edge list to matrix
#' @description Convert an edge list to a matrix.
#' @param df a data frame contening at leas three columns with the names: 'from','to' and 'weight', corresponding respectively to the individual emiting the beaheviour, the individual receving the beahviour, and the number of time this interaction occure.
#' @param sym a boolean if TRUE then the interactions are concider to be symetric.
#' @return A square adjacency matrix.
#' @details Adjacency matrix is one of the numerous representation of a social network.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
edgl_to_matrix <- function(df, sym) {
    .Call(`_ANTs_edgl_to_matrix`, df, sym)
}

euclidean <- function(vec) {
    .Call(`_ANTs_euclidean`, vec)
}

#' @title Empty group by individual matrix
#' @description Create an embty group by individual matrix according to the number of scans and individuals.
#' @param d a data frame 
#' @param col_scan an integer indicating the number of the column holding the different scans.
#' @param col_id an integer indicating the number of the column holding the different scans.
#' @return An empty group by individual matrix.
#' @details A group by individual matrix is a way to represent several data collection protocols such as gambit of the groups or scans data collections. They also allow to compute easely several associations indexes.
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
gbi_createEmpty <- function(d, col_scan, col_id) {
    .Call(`_ANTs_gbi_createEmpty`, d, col_scan, col_id)
}

#' @title Merge list of data frames 
#' @description Merge a list of  data frames keeping the structure of the first one
#' @keywords internal
ldf_merge <- function(ldf) {
    .Call(`_ANTs_ldf_merge`, ldf)
}

#' @title Merge columns of a List of data frames.
#' @description perm_dataStraem_focal subfunction to concatenate the columns of alters of a list of data frames.
#' @param df a data frame to know the total size of the concatenated vector.
#' @param ldf a list of data frames in wich extarct a single column.
#' @param col an integer indicating wich column of the data frames extract. Is a R indexation.
#' @return A character vector.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
listDf_merge_single_column <- function(df, ldf, col) {
    .Call(`_ANTs_listDf_merge_single_column`, df, ldf, col)
}

#' @title Lapply function
#' @description C++ version of lapply function.
#' @param input a list.
#' @param f a function to apply along the list. 
#' @return A list with the output type of the function.
#' @author This function have been copy from Rcpp gallery: XXXX
#' @keywords internal
list_lapply <- function(input, f) {
    .Call(`_ANTs_list_lapply`, input, f)
}

#' @title List to data frame.
#' @description Convert a list of vectors into a data frame
#' @param lst a list.
#' @return A data frame with the same number of columns as the list length.
#' @keywords internal
list_to_df <- function(a) {
    .Call(`_ANTs_list_to_df`, a)
}

#' @title Matrix binarization.
#' @description Convert matrix element higher to one in zeros.
#' @param M a data frame to know the total size of the concatenated vector.
#' @return A matrix.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_binaryzation <- function(M) {
    .Call(`_ANTs_mat_binaryzation`, M)
}

mat_col_extract <- function(m, x) {
    .Call(`_ANTs_mat_col_extract`, m, x)
}

#' @title Binary version of column sum.
#' @description Count the number of non empty cells of each columns of an adjacency matrix.
#' @param m a matrix.
#' @return An integer vector. Each elements correspond to the sum of non empty cells according to the corresponding column.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_col_sumsBinary <- function(m) {
    .Call(`_ANTs_mat_col_sumsBinary`, m)
}

#' @title From Column Sums.
#' @description Column Sums of an adjacency matrix.
#' @param m a matrix.
#' @return An integer vector. Each elements correspond to the sum of the corresponding column.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_cols_sums <- function(m) {
    .Call(`_ANTs_mat_cols_sums`, m)
}

#' @title Dimensions of a matrix
#' @description Retrieve or set the dimension of Matrix.
#' @param m a matrix.
#' @return A numeric vector with two elements. The first one correspond to the number of row and the second one correspond to the number of columns.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_dim <- function(m) {
    .Call(`_ANTs_mat_dim`, m)
}

mat_erase_col <- function(M, a) {
    .Call(`_ANTs_mat_erase_col`, M, a)
}

mat_fill_upper <- function(m) {
    .Call(`_ANTs_mat_fill_upper`, m)
}

#' @title Matrix filtering
#' @description Filtering matrix cells according to a threshold and replace them by a bouble.
#' @param m a matrix.
#' @param threshold a value above wich the cells of the matrix will be keep.
#' @param replace a doubl eindicating the value by which replace the replace elements.
#' @return A matix.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_filter <- function(m, threshold, replace) {
    .Call(`_ANTs_mat_filter`, m, threshold, replace)
}

#' @title Find zeros in a Matrix.
#' @description Find empty cells in a matrix.
#' @param m a matrix.
#' @return A data frame with two columns the first one representing the row id and the second one trepresenting the column id of the zero cell.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_find0 <- function(m) {
    .Call(`_ANTs_mat_find0`, m)
}

#' @title Is square.
#' @description Test if a matrix is square or not.
#' @param m a matrix.
#' @return a boolean indicating if the matrix is square or not.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_isSquare <- function(m) {
    .Call(`_ANTs_mat_isSquare`, m)
}

mat_lowertri_to_vec <- function(m, diag) {
    .Call(`_ANTs_mat_lowertri_to_vec`, m, diag)
}

#' @title Extract matrix row.
#' @description Extract a specific row of a matrix.
#' @param m a matrix.
#' @param int na integer indicating the row number to extract.
#' @return An integer vector corresponding the row extract.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_row_extract <- function(m, x) {
    .Call(`_ANTs_mat_row_extract`, m, x)
}

#' @title From row Sums.
#' @description row Sums of an adjacency matrix.
#' @param m a matrix.
#' @return An integer vector. Each elements correspond to the sum of the corresponding row.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_rows_sums <- function(x) {
    .Call(`_ANTs_mat_rows_sums`, x)
}

#' @title Binary version of row sum.
#' @description Count the number of non empty cells of each row of an adjacency matrix.
#' @param m a matrix.
#' @return An integer vector. Each elements correspond to the sum of non empty cells according to the corresponding row.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @keywords internal
mat_rows_sumsBinary <- function(x) {
    .Call(`_ANTs_mat_rows_sumsBinary`, x)
}

mat_row_wise_multiplication <- function(m, v) {
    .Call(`_ANTs_mat_row_wise_multiplication`, m, v)
}

mat_sym_by_lowertri <- function(M) {
    .Call(`_ANTs_mat_sym_by_lowertri`, M)
}

mat_symetrization <- function(M) {
    .Call(`_ANTs_mat_symetrization`, M)
}

mat_to_vec <- function(M, ncol) {
    .Call(`_ANTs_mat_to_vec`, M, ncol)
}

met_assor_cat <- function(M, att) {
    .Call(`_ANTs_met_assor_cat`, M, att)
}

met_degree <- function(M) {
    .Call(`_ANTs_met_degree`, M)
}

met_density <- function(M) {
    .Call(`_ANTs_met_density`, M)
}

met_eigen <- function(M, eps = 0.000001, maxiter = 1000L) {
    .Call(`_ANTs_met_eigen`, M, eps, maxiter)
}

met_indegree <- function(M) {
    .Call(`_ANTs_met_indegree`, M)
}

met_nalters <- function(M) {
    .Call(`_ANTs_met_nalters`, M)
}

met_outdegree <- function(M) {
    .Call(`_ANTs_met_outdegree`, M)
}

#' @title strength
#' @description Calculate for all the vertices the node metric call strentgh.
#' @param M a square adjacency matrix.
#' @return Integer vector of each vertices outstrentgh.
#' @details  strength of vertice \emph{i} is all edges //' @title Outstrength
#' @description Calculate for all the vertices the node metric call outstrentgh.
#' @param M a square adjacency matrix.
#' @return Integer vector of each vertices outstrentgh.
#' @author Sebastian Sosa, Ivan Puga-Gonzales.
#' @references Barrat, A., Barthelemy, M., Pastor-Satorras, R., & Vespignani, A. (2004). The architecture of complex weighted networks. Proceedings of the National Academy of Sciences of the United States of America, 101(11), 3747-3752.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
met_strength <- function(M) {
    .Call(`_ANTs_met_strength`, M)
}

met_sum_egos_strength <- function(M) {
    .Call(`_ANTs_met_sum_egos_strength`, M)
}

na_omit <- function(x) {
    .Call(`_ANTs_na_omit`, x)
}

#' @title Data Stream gambit of the group Permutations without control factor.
#' @description Pre-network permutation on association data of gambit of the group type without control factor.
#' @param M a square adjacency matrix.
#' @details  Data stream permutations is a pre-network permutations approach. It is use on association data based on the gambit of the group. This permutations functunction is made for  data collected of the type of 'gambit of the group' and without control factors
#' @param M a square adjacency matrix.
#' @param nperm an integer indicating the number of permutations to perform.
#' @param progress a boolean indicating if you wich to see the progression of the permutations.
#' @return A list of Group By Individual matrices according to each scans perform.
#' @author Ivan Puga-Gonzales, Sebastian Sosa.
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
perm_dataStream1 <- function(M, nperm, progress, method) {
    .Call(`_ANTs_perm_dataStream1`, M, nperm, progress, method)
}

#' @title Data Stream gambit of the group Permutations without control factor.
#' @description Pre-network permutation on association data of gambit of the group type without control factor.
#' @param M a square adjacency matrix.
#' @details  Data stream permutations is a pre-network permutations approach. It is use on association data based on the gambit of the group. This permutations functunction is made for  data collected of the type of 'gambit of the group' and without control factors
#' @param M a square adjacency matrix.
#' @param nperm an integer indicating the number of permutations to perform.
#' @param progress a boolean indicating if you wich to see the progression of the permutations.
#' @return A list of Group By Individual matrices according to each scans perform.
#' @author Ivan Puga-Gonzales, Sebastian Sosa.
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
perm_dataStream1_focal <- function(M, M2, nperm, progress, method) {
    .Call(`_ANTs_perm_dataStream1_focal`, M, M2, nperm, progress, method)
}

#' @title Data Stream gambit of the group Permutations with control factor.
#' @description Pre-network permutation on association data of gambit of the group type with control factor. 
#' @param M a square adjacency matrix.
#' @param nperm an integer indicating the number of permutations to perform.
#' @param CumSizesGbis ???
#' @param progress a boolean indicating if you wich to see the progression of the permutations.
#' @return A list of Group By Individual matrices according to each scans perform.
#' @details  Data stream permutations is a pre-network permutations approach. It is use on association data based on the gambit of the group. This permutations functunction is made for  data collected of the type of 'gambit of the group' and without control factors
#' @author Ivan Puga-Gonzales, Sebastian Sosa.
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
perm_dataStream_ControlFactor <- function(GBIList, M, nperm, GBIIndexes, CumSizesGbis, progress, method) {
    .Call(`_ANTs_perm_dataStream_ControlFactor`, GBIList, M, nperm, GBIIndexes, CumSizesGbis, progress, method)
}

#' @title Vectorize matrix permutation
#' @description Permute rows and columns of a vectorized matrix
#' @param vec a vumeric matrix
#' @param n number of columns of the original matrix
#' @param rand a numeric vector of randomized column and rows indeces
#' @details It's the equivalent of R m[rand, rand] function. Columns and rows indexatons are in R format.
#' @return A vector
#' @author Sebastian Sosa.
#' @keywords internal
perm_matVec <- function(vec, n, rand) {
    .Call(`_ANTs_perm_matVec`, vec, n, rand)
}

perm_mat_col_row <- function(M, ncol, rand) {
    .Call(`_ANTs_perm_mat_col_row`, M, ncol, rand)
}

#' @title Edgelist weigths permutations
#' @description Post-network permutations on links weights.
#' @keywords internal
perm_net_weigths <- function(df, sym, nperm, progress) {
    .Call(`_ANTs_perm_net_weigths`, df, sym, nperm, progress)
}

#' @title Node lable permutation with random factors
#' @description Perorm node label permutation on list of data frames
#' @keywords internal
perm_nl_rf <- function(ldf, lables, nperm, progress) {
    .Call(`_ANTs_perm_nl_rf`, ldf, lables, nperm, progress)
}

#' @title Node label permutations.
#' @description Post-network permutations of the type 'node labels'.
#' @param df a data frame.
#' @param label a numeric vector indicating the number of individuals.
#' @param nperm an integer indicating the number of permutations to perform.
#' @param progress a boolean indicating if you wich to see the progression of the permutations.
#' @return A list of data frames, each ones holding a different permutation.
#' @details  Node label permutations is a post-network permutations approach that swap the labels of the nodes (e.g. degree). It is use on direct interactions behaviours.
#' @author Sebastian Sosa,Ivan Puga-Gonzales.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
perm_nodeLabels <- function(df, label, nperm, progress) {
    .Call(`_ANTs_perm_nodeLabels`, df, label, nperm, progress)
}

#' @title Permute factor vector.
#' @description Permutes elements of a vector. 
#' @param x a numeric vector.
#' @param progress a boolean indicating if you wich to see the progression of the permutations.
#' @return A list of vectors, each ones holding a different permutation.
#' @details  Permuting a vector can serve to realize node label permutation.
#' @author Sebastian Sosa,Ivan Puga-Gonzales.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
perm_vec_factor <- function(vec) {
    .Call(`_ANTs_perm_vec_factor`, vec)
}

#' @title Vector permutations.
#' @description permutes elements of a vector. 
#' @param x a numeric vector.
#' @param perm an integer indicating the number of permutations to perform.
#' @param progress a boolean indicating if you wich to see the progression of the permutations.
#' @return A list of vectors, each ones holding a different permutation.
#' @details  Permuting a vector can serve to realize node label permutation.
#' @author Sebastian Sosa,Ivan Puga-Gonzales.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
perm_vec_int <- function(x, nperm, progress) {
    .Call(`_ANTs_perm_vec_int`, x, nperm, progress)
}

#' @title Data Stream gambit of the group Permutations without control factor.
#' @description Pre-network permutation on association data of gambit of the group type without control factor.
#' @param M a square adjacency matrix.
#' @details  Data stream permutations is a pre-network permutations approach. It is use on association data based on the gambit of the group. This permutations functunction is made for  data collected of the type of 'gambit of the group' and without control factors
#' @param M a square adjacency matrix.
#' @param nperm an integer indicating the number of permutations to perform.
#' @param progress a boolean indicating if you wich to see the progression of the permutations.
#' @return A list of Group By Individual matrices according to each scans perform.
#' @author Ivan Puga-Gonzales, Sebastian Sosa.
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
redo_perm_dataStream1_focal <- function(M, M2, nperm, method) {
    .Call(`_ANTs_redo_perm_dataStream1_focal`, M, M2, nperm, method)
}

#' @title Data Stream gambit of the group cumulative permutations without control factor.
#' @description Cumulative pre-network permutation on association data of gambit of the group type without control factor.
#' @param M a square adjacency matrix.
#' @param nperm an integer indicating the number of permutations to perform.
#' @details  Data stream permutations is a pre-network permutations approach. It is use on association data based on the gambit of the group. This permutations functunction is made for  data collected of the type of 'gambit of the group' and without control factors
#' @return A list of Group By Individual matrices according to each scans perform.
#' @author Ivan Puga-Gonzales, Sebastian Sosa.
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
redo_perm_dataStream_1 <- function(M, nperm, method) {
    .Call(`_ANTs_redo_perm_dataStream_1`, M, nperm, method)
}

#' @title Data Stream gambit of the group cumulative permutations with control factor.
#' @description Cumulative pre-network permutation on association data of gambit of the group type with control factor. 
#' @param GBIList a list of gbis split according to the control(s) factors.
#' @param nperm an integer indicating the number of permutations to perform.
#' @param CumSizesGbis ???
#' @details  Data stream permutations is a pre-network permutations approach. It is use on association data based on the gambit of the group. This permutations functunction is made for  data collected of the type of 'gambit of the group' and without control factors
#' @author Ivan Puga-Gonzales, Sebastian Sosa.
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
redo_perm_dataStream_ControlFactor <- function(GBIList, M, nperm, CumSizesGbis, method) {
    .Call(`_ANTs_redo_perm_dataStream_ControlFactor`, GBIList, M, nperm, CumSizesGbis, method)
}

#' @title Data Stream gambit of the group cumulative permutations with control factor.
#' @description Cumulative pre-network permutation on association data of gambit of the group type with control factor. 
#' @param GBIList a list of gbis split according to the control(s) factors.
#' @param nperm an integer indicating the number of permutations to perform.
#' @param CumSizesGbis ???
#' @details  Data stream permutations is a pre-network permutations approach. It is use on association data based on the gambit of the group. This permutations functunction is made for  data collected of the type of 'gambit of the group' and without control factors
#' @author Ivan Puga-Gonzales, Sebastian Sosa.
#' @references Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
redo_perm_dataStream_ControlFactor_scd <- function(GBIList, nperm, method) {
    .Call(`_ANTs_redo_perm_dataStream_ControlFactor_scd`, GBIList, nperm, method)
}

#' @title Data Stream Focal Sampling cumulative permutations without control factor.
#' @description Pre-network cumulative permutation on association data of  Focal Sampling type without control factor.
#' @param df a data frame.
#' @param ldf2 a list of data frames split by individuals focals.
#' @param nperm an integer indicating the number of permutations to perform.
#' @param id_obs a numeric vector with the number of different ids.
#' @param col_focal an integer indicating the column holding the id of the focal.
#' @param col_alters an integer indicating the column holding the id of the alters.
#' @param lengthList an integer vector range from 0 to length of the list (c++ indexation).
#' @return A list of data frames, each ones holding a different permutation.
#' @details  Data stream permutations is a pre-network permutations approach. It is use on association data based on the gambit of the group. This permutations functunction is made for data collected of the type of 'focal sampling' and without control factors
#' @author Sebastian Sosa,Ivan Puga-Gonzales.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
redo_perm_dataStream_focal <- function(df, ldf1, nperm, col_focal, col_alters, lengthList) {
    .Call(`_ANTs_redo_perm_dataStream_focal`, df, ldf1, nperm, col_focal, col_alters, lengthList)
}

test_nm <- function(X) {
    .Call(`_ANTs_test_nm`, X)
}

test_arma <- function(X) {
    .Call(`_ANTs_test_arma`, X)
}

test_nm_conv <- function(X) {
    .Call(`_ANTs_test_nm_conv`, X)
}

test_const_arma <- function(X) {
    .Call(`_ANTs_test_const_arma`, X)
}

met_ei2 <- function(m) {
    .Call(`_ANTs_met_ei2`, m)
}

#' @title Control heterogeneity of time of observation
#'@description repeat a numeric vector n times, where n is the length of this vecctor
#' @author Sebastian Sosa, Ivan Puga-Gonzalez
#' @keywords internal
tobs_to_mat <- function(vec) {
    .Call(`_ANTs_tobs_to_mat`, vec)
}

#' @title As factor
#' @description Transform a vector into a factor vetor.
#' @param vec a vector.
#' @return A vector of same length and order of the input vector.
#' @details  Permuting a vector can serve to realize node label permutation.
#' @author Sebastian Sosa,Ivan Puga-Gonzales.
#' @references Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.
#' @references Sosa, S. (\emph{in press}). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
#' @keywords internal
vec_char_as_factor <- function(vec) {
    .Call(`_ANTs_vec_char_as_factor`, vec)
}

#' @title Extract vector elements
#' @description xtract vector elements according to indices
#' @keywords internal
vec_char_extract_IdValue <- function(y, x) {
    .Call(`_ANTs_vec_char_extract_IdValue`, y, x)
}

vec_num_extract <- function(x, y) {
    .Call(`_ANTs_vec_num_extract`, x, y)
}

#' @title Merge
#' @description Merge two vectors keeping their class
#' @keywords internal
vec_fill <- function(vec1, vec2, x) {
    .Call(`_ANTs_vec_fill`, vec1, vec2, x)
}

vec_id_Equal0 <- function(x) {
    .Call(`_ANTs_vec_id_Equal0`, x)
}

vec_id_sup0 <- function(x) {
    .Call(`_ANTs_vec_id_sup0`, x)
}

#' @title intersect
#' @description extract element present in none of the two vectors
#' @keywords internal
vec_intersect <- function(x, y) {
    .Call(`_ANTs_vec_intersect`, x, y)
}

#' @title Uniques
#' @description find uniques elements in a vector
#' @keywords internal
vec_levels <- function(v) {
    .Call(`_ANTs_vec_levels`, v)
}

#' @title Vector to matrix lower triangle
#' @description Create a matrix from a vector 
#' @param vec a numeric vector
#' @param col number of columns of the matrix to create
#' @param diag doe diagonal is included
#' @section Warning: Argument vec must be of the exact same length of the number of cells present in the lower triangle of the amtrix to create. 
#' @return A vector
#' @author Sebastian Sosa.
#' @keywords internal
vec_lowertri_to_mat <- function(vec, col, diag) {
    .Call(`_ANTs_vec_lowertri_to_mat`, vec, col, diag)
}

vec_match <- function(x, y) {
    .Call(`_ANTs_vec_match`, x, y)
}

vec_merge <- function(vec1, vec2) {
    .Call(`_ANTs_vec_merge`, vec1, vec2)
}

#' @title Extract ID
#' @description Extract ID of element selected by a numeric vector
#' @keywords internal
vec_num_extract_IdValue <- function(y, x) {
    .Call(`_ANTs_vec_num_extract_IdValue`, y, x)
}

vec_resize <- function(vec, x) {
    .Call(`_ANTs_vec_resize`, vec, x)
}

#' @title Vector sample
#' @description Sample vetor keeping his class
#' @keywords internal
vec_sample <- function(vec1, length, replace) {
    .Call(`_ANTs_vec_sample`, vec1, length, replace)
}

vec_sample_all <- function(vec) {
    .Call(`_ANTs_vec_sample_all`, vec)
}

#' @title Sum
#' @description Sum vector elements
#' @keywords internal
vec_sum <- function(x) {
    .Call(`_ANTs_vec_sum`, x)
}

#' @title Vector to matrix
#' @description Create a matrix from a vector
#' @param vec a numeric vector
#' @param n number of columns of the matrix to create
#' @param diag a boolean indicating with the argument vec have the diagonal information in it.
#' @return A square matrix
#' @author Sebastian Sosa.
#' @keywords internal
vec_to_mat <- function(vec, ncol, diag) {
    .Call(`_ANTs_vec_to_mat`, vec, ncol, diag)
}

#' @title Vector to matrix and adding diag
#' @description Create a matrix from a vector
#' @param vec a numeric vector
#' @param n number of columns of the matrix to create
#' @return A square matrix
#' @author Sebastian Sosa.
#' @keywords internal
vec_to_mat_add_diag <- function(vec, ncol) {
    .Call(`_ANTs_vec_to_mat_add_diag`, vec, ncol)
}

#' @title Vector uniques
#' @description Find uniques element of one vecotr
#' @keywords internal
vec_unique <- function(v) {
    .Call(`_ANTs_vec_unique`, v)
}

vec_unmatch <- function(x, y) {
    .Call(`_ANTs_vec_unmatch`, x, y)
}

vec_unmatch_indexcc <- function(x, y) {
    .Call(`_ANTs_vec_unmatch_indexcc`, x, y)
}

#' @title Vectors multiply
#' @description Multiply two vectors
#' @keywords internal
vec_vec_multiply <- function(x, y) {
    .Call(`_ANTs_vec_vec_multiply`, x, y)
}

#' @title Vectors multiply
#' @description Multiply two vectors
#' @keywords internal
vec_vec_sum <- function(x, y) {
    .Call(`_ANTs_vec_vec_sum`, x, y)
}

vector_abs <- function(vec) {
    .Call(`_ANTs_vector_abs`, vec)
}

#' @title Equal
#' @description Find matrix element corresponding to an integer
#' @keywords internal
which_equal <- function(M, x) {
    .Call(`_ANTs_which_equal`, M, x)
}

