% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.to.mat.R
\name{df.to.mat}
\alias{df.to.mat}
\title{Data frame to a matrix}
\usage{
df.to.mat(
  df,
  actor,
  receiver,
  weighted = NULL,
  tobs = NULL,
  sym = FALSE,
  num.ids = FALSE
)
}
\arguments{
\item{df}{a data frame of interactions or associations.}

\item{actor}{an integer or a string indicating the column of the individuals performing the behaviour.}

\item{receiver}{an integer or a string indicating the column of the individuals receiving the behaviour.}

\item{weighted}{an integer or a string indicating the column of the weights of interactions. If NULL, interactions are given a weight of 1.}

\item{tobs}{an numeric vector or a list of numeric vectors of each individual time of observation. It has to be alphabetically ordered following unique id names.}

\item{sym}{a boolean if \emph{true}, interactions or associations are considered symmetric.}

\item{num.ids}{a boolean if \emph{true}, it returns ordered matrix according to the numeric ids.}
}
\value{
An adjacency matrix (undirected if argument \emph{sym} is true, directed otherwise).
}
\description{
Converts a data frame into a matrix.
}
\details{
Converts a data frame of interactions or associations into an adjacency matrix of interactions or associations.
}
\examples{
head(sim.focal.directed)
df.to.mat(df=sim.focal.directed,actor='actor', receiver='receiver')
}
