% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendall.concordance.R
\name{kendall.concordance}
\alias{kendall.concordance}
\title{Calculate Kendall's concordance}
\usage{
kendall.concordance(
  y,
  groups,
  blocks,
  max.exact.perms = 1e+05,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{y}{Numeric vector of same length as groups, blocks}

\item{groups}{Factor of same length as y, blocks with levels such that length(y) == nlevels(groups) * nlevels(blocks)}

\item{blocks}{Factor of same length as y, groups with levels such that length(y) == nlevels(groups) * nlevels(blocks)}

\item{max.exact.perms}{Maximum number of permutations allowed for exact calculations (defaults to \code{100000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{10000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMstat object with the results from applying the function
}
\description{
\code{kendall.concordance()} calculates Kendall's concordance and is used in chapter 10 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Exercise 10.11 from "Applied Nonparametric Statistical Methods" (5th edition)
kendall.concordance(ch10$marks, ch10$script, ch10$examiner, do.exact = FALSE, do.asymp = TRUE)
kendall.concordance(ch10$marks, ch10$examiner, ch10$script, do.exact = FALSE, do.asymp = TRUE)

}
