% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lilliefors.R
\name{lilliefors}
\alias{lilliefors}
\title{Performs Lilliefors test of Normality}
\usage{
lilliefors(x, alternative = c("two.sided"), nsims.mc = 10000, seed = NULL)
}
\arguments{
\item{x}{Numeric vector}

\item{alternative}{Type of alternative hypothesis (defaults to \code{c("two.sided")})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{10000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{lilliefors()} performs Lilliefors test of Normality and is used in chapters 4, 5 and 6 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 4.4 from "Applied Nonparametric Statistical Methods" (5th edition)
lilliefors(ch4$ages, seed = 1)

# Exercise 6.15 from "Applied Nonparametric Statistical Methods" (5th edition)
lilliefors(ch6$doseI.2, seed = 1, nsims = 1000)

}
