% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hettmansperger.elmore.R
\name{hettmansperger.elmore}
\alias{hettmansperger.elmore}
\title{Perform Hettmansperger and Elmore interaction test}
\usage{
hettmansperger.elmore(
  y,
  factor.a,
  factor.b,
  nsims.mc = 1000,
  seed = NULL,
  do.asymp = TRUE,
  do.mc = FALSE,
  median.polish = FALSE
)
}
\arguments{
\item{y}{Numeric vector of same length as factor.a, factor.b}

\item{factor.a}{Factor of same length as y, factor.b}

\item{factor.b}{Factor of same length as y, factor.a}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{1000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{TRUE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}

\item{median.polish}{Boolean indicating whether or not to use median polish (defaults to \code{FALSE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{hettmansperger.elmore()} performs the Hettmansperger and Elmore interaction test and is used in chapter 8 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 8.6 from "Applied Nonparametric Statistical Methods" (5th edition)
hettmansperger.elmore(ch8$plant.weight.2, ch8$growth.hormone, ch8$undersoil.heating)

# Exercise 8.3 from "Applied Nonparametric Statistical Methods" (5th edition)
hettmansperger.elmore(ch8$game.time, ch8$experience, ch8$game)

}
