% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ab.R
\name{as.ab}
\alias{as.ab}
\alias{is.ab}
\title{Transform to antibiotic ID}
\usage{
as.ab(x)

is.ab(x)
}
\arguments{
\item{x}{character vector to determine to antibiotic ID}
}
\value{
Character (vector) with class \code{"ab"}. Unknown values will return \code{NA}.
}
\description{
Use this function to determine the antibiotic code of one or more antibiotics. The data set \code{\link{antibiotics}} will be searched for abbreviations, official names and synonyms (brand names).
}
\details{
All entries in the \code{\link{antibiotics}} data set have three different identifiers: a human readable EARS-Net code (column \code{ab}, used by ECDC and WHONET), an ATC code (column \code{atc}, used by WHO), and a CID code (column \code{cid}, Compound ID, used by PubChem). The data set contains more than 5,000 official brand names from many different countries, as found in PubChem.

Use the \code{\link{ab_property}} functions to get properties based on the returned antibiotic ID, see Examples.
}
\section{Source}{

World Health Organization (WHO) Collaborating Centre for Drug Statistics Methodology: \url{https://www.whocc.no/atc_ddd_index/}

WHONET 2019 software: \url{http://www.whonet.org/software.html}

European Commission Public Health PHARMACEUTICALS - COMMUNITY REGISTER: \url{http://ec.europa.eu/health/documents/community-register/html/atc.htm}
}

\section{WHOCC}{

\if{html}{\figure{logo_who.png}{options: height=60px style=margin-bottom:5px} \cr}
This package contains \strong{all ~450 antimicrobial drugs} and their Anatomical Therapeutic Chemical (ATC) codes, ATC groups and Defined Daily Dose (DDD) from the World Health Organization Collaborating Centre for Drug Statistics Methodology (WHOCC, \url{https://www.whocc.no}) and the Pharmaceuticals Community Register of the European Commission (\url{http://ec.europa.eu/health/documents/community-register/html/atc.htm}).

These have become the gold standard for international drug utilisation monitoring and research.

The WHOCC is located in Oslo at the Norwegian Institute of Public Health and funded by the Norwegian government. The European Commission is the executive of the European Union and promotes its general interest.
}

\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
# These examples all return "ERY", the ID of Erythromycin:
as.ab("J01FA01")
as.ab("J 01 FA 01")
as.ab("Erythromycin")
as.ab("eryt")
as.ab("   eryt 123")
as.ab("ERYT")
as.ab("ERY")
as.ab("eritromicine") # spelled wrong, yet works
as.ab("Erythrocin")   # trade name
as.ab("Romycin")      # trade name

# Use ab_* functions to get a specific properties (see ?ab_property);
# they use as.ab() internally:
ab_name("J01FA01")    # "Erythromycin"
ab_name("eryt")       # "Erythromycin"
}
\seealso{
\code{\link{antibiotics}} for the dataframe that is being used to determine ATCs.
}
\keyword{atc}
