% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlantArea.R
\docType{methods}
\name{plantAreaDensity}
\alias{plantAreaDensity}
\title{Plant Area Density (PAD)}
\usage{
plantAreaDensity(
  vxsp,
  lad = "spherical",
  angle.name = "angleMean",
  variable.name = c("transmittance", "attenuation_FPL_unbiasedMLE",
    "attenuation_PPL_MLE"),
  pad.max = 5,
  pulse.min = 5,
  ...
)
}
\arguments{
\item{vxsp}{a \code{\link{VoxelSpace-class}} object.}

\item{lad}{the name of the probability density function of the leaf angle
distribution. One of \code{AMAPVox:::leafAngleDistribution}.}

\item{angle.name}{the name of the mean angle variable in the VoxelSpace
object.}

\item{variable.name}{the name of the transmittance/attenuation variables in
the VoxelSpace object. Transmittance variables are expected to start with
"tra" and attenuation variables with "att".}

\item{pad.max}{a float, the maximal PAD value}

\item{pulse.min}{an integer, the minimal number of pulses in a voxel for
computing the PAD. PAD set to NA otherwise.}

\item{...}{additional parameters which will be passed to the leaf angle
distribution functions. Details in \link{computeG}.}
}
\value{
A voxel space object with the requested PAD variables.
}
\description{
Computes Plant Area Density either from transmittance or
attenuation coefficient estimates.
Details of calculation and underlying assumptions can be found online at
\doi{10.23708/1AJNMP}.
PAD is defind as the plant area per unit volume
( PAD plant area / voxel volume = m^2 / m^3).
}
\references{
VINCENT, Gregoire; PIMONT, François; VERLEY, Philippe, 2021,
"A note on PAD/LAD estimators implemented in AMAPVox 1.7",
\doi{10.23708/1AJNMP}, DataSuds, V1
}
\seealso{
\link{computeG}
}
