% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Butterfly.R
\docType{methods}
\name{butterfly}
\alias{butterfly}
\title{Identify butterflies from a VoxelSpace object.}
\usage{
butterfly(vxsp)
}
\arguments{
\item{vxsp}{a \code{\link{VoxelSpace-class}} object}
}
\value{
a list of voxel index (i, j, k) identified as butterfly in a
\link[data.table:data.table]{data.table::data.table}
}
\description{
Identify butterflies from a \code{\link{VoxelSpace-class}} object.

A butterfly refers to a non-empty isolated voxel. Non-empty means that there
is one or more hits recorded in the voxel. Isolated means that voxels in the
\href{https://en.wikipedia.org/wiki/Moore_neighborhood}{Moore neighborhood}
of rank 1 are empty (no hit).
}
\examples{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# identify butterflies
btf <- butterfly(vxsp)
# clear butterflies
clear(vxsp, butterfly(vxsp))
}
\seealso{
\link{clear}
}
