% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMAPVoxGenerics.R, R/AMAPVoxGetters.R
\docType{methods}
\name{getResolution}
\alias{getResolution}
\alias{getResolution,VoxelSpace-method}
\title{Gets the elemental size of a voxel (dx, dy, dz) in meter.}
\usage{
getResolution(voxelSpace)

\S4method{getResolution}{VoxelSpace}(voxelSpace)
}
\arguments{
\item{voxelSpace}{the \code{\link{VoxelSpace-class}} object.}
}
\value{
the size of the voxel in meter, as a numerical vector.
}
\description{
Gets the elemental size of a voxel (dx, dy, dz) in meter.
}
\examples{
# load a voxel file
vox <- readVoxelSpace(system.file("extdata", "als_sample.vox", package = "AMAPVox"))
# retrieve 'resolution' parameter
getResolution(vox)
}
