% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ALTopt.R
\name{alteval.rc}
\alias{alteval.rc}
\title{Design evaluation with right censoring.}
\usage{
alteval.rc(designTable, optType, tc, nf, alpha, formula, coef, useCond,
  useLower, useUpper)
}
\arguments{
\item{designTable}{a data frame containing the coordinates and the number of
allocation of each design point. The design created by either
\code{\link{altopt.rc}} or \code{\link{altopt.ic}} or any design matrix
with the same form as those can be provided for this argument.}

\item{optType}{the choice of \code{"D"}, \code{"U"} and \code{"I"} optimality.}

\item{tc}{the censoring time.}

\item{nf}{the number of stress factors.}

\item{alpha}{the value of the shape parameter of Weibull distribution.}

\item{formula}{the object of class formula which is the linear predictor model.}

\item{coef}{the numeric vector containing the coefficients of each term in \code{formula}.}

\item{useCond}{the numeric vector of use condition.
It should be provided when \code{optType} is \code{"U"}. The length of the vector
should be same as the number of stress factors.}

\item{useLower}{the numeric vector of lower bound of use region.
It should be provided when \code{optType} is \code{"I"}. The length of the vector
should be same as the number of stress factors.}

\item{useUpper}{the numeric vector of upper bound of use region.
It should be provided when \code{optType} is \code{"I"}. The length of the vector
should be same as the number of stress factors.}
}
\value{
The objective function value corresponded by \code{optType}
  for a given design with right censoring plan.
}
\description{
\code{\link{alteval.rc}} calculates the objective function value
  (D, U or I) for a given design with right censoring plan.
}
\examples{
# Evaluation of factorial design for right censoring.
x1 <- c(0, 1, 0, 1)
x2 <- c(0, 0, 1, 1)
allocation <- c(25, 25, 25, 25)
facDes <- data.frame(x1, x2, allocation)

alteval.rc(facDes, "D", 100, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01))

alteval.rc(facDes, "U", 100, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01), useCond = c(1.758, 3.159))

alteval.rc(facDes, "I", 100, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01), useLower = c(1.458, 2.859), useUpper = c(2.058, 3.459))
}
\seealso{
\code{\link{altopt.rc}}
}

