% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occurrences_s3.R
\name{occurrences_s3}
\alias{occurrences_s3}
\alias{summary.occurrences}
\alias{unique.occurrences}
\alias{subset.occurrences}
\title{Summarize, filter and subset occurrence data}
\usage{
\method{summary}{occurrences}(object, ...)

\method{unique}{occurrences}(
  x,
  incomparables = FALSE,
  spatial = 0,
  temporal = NULL,
  na.rm = FALSE,
  ...
)

\method{subset}{occurrences}(
  x,
  remove.fatal = TRUE,
  exclude.spatial = "error",
  exclude.temporal = "error",
  exclude.taxonomic = "error",
  max.spatial.uncertainty,
  keep.missing.spatial.uncertainty = TRUE,
  ...
)
}
\arguments{
\item{object}{list: an 'occurrence' object that has been downloaded using
\code{\link{occurrences}}}

\item{\dots}{not currently used}

\item{x}{list: an 'occurrence' object that has been downloaded using
\code{\link{occurrences}}}

\item{incomparables}{logical/numeric: currently ignored, but needed for S3
method consistency}

\item{spatial}{numeric: specifies a rounding value in decimal degrees used
to create a unique subset of the data. Value of 0 means no rounding and use
values as is. Values <0 mean ignore spatial unique parameter}

\item{temporal}{character: specifies the temporal unit for which to keep
unique records; this can be by "year", "month", "yearmonth" or "full" date.
NULL means ignore temporal unique parameter}

\item{na.rm}{logical: keep (FALSE) or remove (TRUE) missing spatial or
temporal data}

\item{remove.fatal}{logical: remove flagged assertion issues that are
considered "fatal"; see \code{\link{check_assertions}}}

\item{exclude.spatial}{character vector: defining flagged spatial assertion
issues to be removed. Values can include 'warnings','error','missing',
'none'; see \code{\link{check_assertions}}}

\item{exclude.temporal}{character vector: defining flagged temporal
assertion issues to be removed. Values can include 'warnings','error',
'missing','none'; see \code{\link{check_assertions}}}

\item{exclude.taxonomic}{character vector: defining flagged taxonomic
assertion issues to be removed. Values can include 'warnings','error',
'missing','none'; see \code{\link{check_assertions}}}

\item{max.spatial.uncertainty}{numeric: number defining the maximum spatial
uncertainty (in meters) one is willing to accept.}

\item{keep.missing.spatial.uncertainty}{logical: keep (FALSE) or remove
(TRUE) information missing spatial uncertainty data.}
}
\description{
Set of S3 methods to summarize, filter and get unique occurrence data
retrieved using \code{\link{occurrences}}.
This uses information based on selections of assertions (quality assurance
issues ALA has identified), spatial and temporal data.
}
\details{
\code{unique} will give the min value for all columns that are not used in
the aggregation.
}
\examples{
\dontrun{
#download some observations
x <- occurrences(taxon = "Amblyornis newtonianus",download_reason_id = 10,
email = "ala4r@ala.org.au")

#summarize the occurrences
summary(x)

#keep spatially unique data at 0.01 degrees (latitude and longitude)
tt <- unique(x,spatial = 0.01)
summary(tt)

#keep spatially unique data that is also unique year/month for the
#collection date
tt <- unique(x,spatial = 0,temporal = 'yearmonth')
summary(tt)

#keep only information for which fatal or "error" assertions do not exist
tt <- subset(x)
summary(tt)
}
}
\references{
\url{https://api.ala.org.au/}

\url{http://stat.ethz.ch/R-manual/R-devel/library/methods/html/Methods.html}
}
