\name{pvalue}
\alias{pvalue}
\title{ Calculates the p-value }
\description{
  Calculates the repeated or stage-wise adjusted p-value of a GSD or a AGSD
}
\usage{
pvalue(object, type = "b")
}
\arguments{
  \item{object}{ object of the \code{class} \code{GSTobj} or of the \code{class} \code{AGSTobj}}
  \item{type}{ p-value type: repeated "r", stage-wise ordering "so" or both "b" (default: "b") }
}
\details{
  \code{object} can be an object of the \code{class} \code{GSTobj} or an object of the \code{class} \code{AGSTobj}. 
  The function identifies the \code{class} of the object and calculates the corresponding p-value (classical or adaptive).
  
  If \code{object} has \code{class} \code{GSTobj}, then a p-value for a classical GSD is calculated.
  \code{type} defines the type of confidence interval that is calculated
  \tabular{ll}{
    \code{"r"}\tab Repeated p-value for a classical GSD\cr
    \code{"so"}\tab Stage-wise adjusted p-value for a classical GSD\cr
    \code{"b"}\tab both: repeated and stage-wise adjusted p-value for a classical GSD\cr
  }
  If \code{object} has \code{class} \code{AGSTobj}, then a p-value for a GSD with design adaptation is calculated.
  \code{type} defines the type of confidence interval that is calculated 
  \tabular{ll}{
    \code{"r"}\tab Repeated p-value for a GSD with design adaptations\cr
    \code{"so"}\tab Stage-wise adjusted p-value for a GSD with design adaptations\cr
    \code{"b"}\tab both: repeated and stage-wise adjusted p-value for a GSD with design adaptations\cr
  }  
}
\value{
  The function \code{pvalue} returns according to the \code{object} the classical or adaptive p-value for the final stage.
  If the parameter value has the \code{class} \code{GSTobj} the classical p-value is calculated. If the 
  parameter value has the \code{class} \code{AGSTobj} the adaptive p-value is calculated.
  
  The calculated p-values are saved as:
  
  \item{pvalue.r}{ repeated p-value}
  \item{pvalue.so}{ stage-wise adjusted p-value}
  
}
\note{
The stage-wise adjusted p-value can only be calculated at the stage where the trial stops and is only valid if the stopping rule is met.

The repeated p-value can be calculated at every stage of the trial and
not just at the stage where the trial stops and is also valid if the stopping rule is not met. 

For calculating the sequential p-values at stage \code{T} the user has to specify the outcome \code{GSDo} in the object \code{GSTobj}
or \code{sTo} (secondary trial outcome) in the object \code{AGSTobj}. A trial outcome is a list of the form 
\code{list=(T=stage of interim analysis, z = interim z-statistic)}; see the example below.
}
\references{ 
Brannath, W, Mehta, CR, Posch, M (2008) ''Exact confidence bounds following
adaptive group sequential tests'', \emph{Biometrics} accepted.

Jennison, C, Turnbull, BW (1989) ''Repeated confidence intervals for group
sequential clinical trials'', \emph{Contr. Clin. Trials}, 5, 33-45.

Mehta, CR, Bauer, P, Posch, M, Brannath, W (2007) ''Repeated confidence
intervals for adaptive group sequential trials'', \emph{Statistics in Medicine}, 26, 5422-5433.

Mueller, HH, Schaefer, H (2001) ''Adaptive group sequential design for clinical
trials: Combining the advantages of adaptive and of classical group sequential
approaches'', \emph{Biometrics}, 57, 886-891. 

Tsiatis,AA, Rosner,GL, Mehta,CR (1984) ''Exact confidence intervals
following a group sequential test'', \emph{Biometrics}, 40, 797-804.
}
\author{ Niklas Hack \email{niklas.hack@meduniwien.ac.at} and Werner Brannath \email{werner.brannath@meduniwien.ac.at} }
\seealso{\code{\link{AGSTobj}}, \code{\link{GSTobj}} }
\examples{
##The following calculates the repeated p-value of a group sequential trial

GSD=plan.GST(K=4,SF=1,phi=0,alpha=0.025,delta=6,pow=0.8,compute.alab=TRUE,compute.als=TRUE)

GST<-as.GST(GSD=GSD,GSDo=list(T=2, z=3.1))
pvalue(GST,type="r")

##The stage-wise adjusted p-value of a group sequential trial is calculated by

pvalue(GST,type="so")

##The repeated p-value at the earlier stage T=1 where the trial stopping rule is not met.

pvalue(as.GST(GSD,GSDo=list(T=1,z=0.7)),type="r")

\dontrun{
##If the stage-wise adjusted p-value is calculated at this stage, 
##the function returns an error message

pvalue(as.GST(GSD,GSDo=list(T=1,z=0.7)),type="so")
}

##The repeated and the stage-wise adjusted p-value of a 
##group sequential trial after a design adaptation is calculated by

pT=plan.GST(K=3,SF=4,phi=-4,alpha=0.05,delta=6,pow=0.9,compute.alab=TRUE,compute.als=TRUE)

iD=list(T=1, z=1.090728)

swImax=0.0625

I2min=3*swImax
I2max=3*swImax

sT=adapt(pT=pT,iD=iD,SF=1,phi=0,cp=0.8,theta=5,I2min,I2max,swImax)

sTo=list(T=2, z=2.393)

AGST<-as.AGST(pT=pT,iD=iD,sT=sT,sTo=sTo)
pvalue(AGST)

##The repeated p-value at the earlier stage T=2 where the stopping rule is not met.

pvalue(as.AGST(pT,iD,sT,sTo=list(T=2,z=1.7)),type="r")

\dontrun{
##If the stage-wise adjusted p-value is calculated at this stage, 
##the function returns an error message

pvalue(as.AGST(pT,iD,sT,sTo=list(T=2,z=1.7)),type="so")
}
}
\keyword{methods}