% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMFractalDimensionAnalyser.R
\name{getFractalDimensions}
\alias{getFractalDimensions}
\title{Calculate 2D fractal dimensions and scales of an AFM Image}
\usage{
getFractalDimensions(AFMImage, AFMImageFractalDimensionsAnalysis)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}

\item{AFMImageFractalDimensionsAnalysis}{an \code{\link{AFMImageFractalDimensionsAnalysis}} to store the results of the fractal analysis}
}
\value{
a list of \code{\link{AFMImageFractalDimensionMethod}} objects with the calculated fractal dimensions and scales
}
\description{
\code{getFractalDimensions} calculates fractal dimensions and scales of an \code{\link{AFMImage}} with the fd.estim.method from the \code{\link{fractaldim}} package.
}
\examples{
library(AFM)

data(AFMImageOfAluminiumInterface)
print(getFractalDimensions(AFMImageOfAluminiumInterface))
}
\references{
Gneiting2012, Tilmann Gneiting, Hana Sevcikova and Donald B. Percival 'Estimators of Fractal Dimension: Assessing the Roughness of Time Series and Spatial Data - Statistics in statistical Science, 2012, Vol. 27, No. 2, 247-277'
}
\seealso{
\code{\link{fractaldim}}
}
\author{
M.Beauvais
}
