% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cortools.R
\name{covEM}
\alias{covEM}
\title{Covariance matrix computation with multiple imputation}
\usage{
covEM(dat_missing, iters = 1000)
}
\arguments{
\item{dat_missing}{a matrix with missing values}

\item{iters}{the number of iterations to perform to estimate missing values}
}
\description{
This function computes a covariance matrix from data with some values missing at random.
The code was written by Eric from StackExchange. https://stats.stackexchange.com/questions/182718/ml-covariance-estimation-from-expectation-maximization-with-missing-data
}
\examples{
# make data with missing values
missing_mtcars <- mtcars
for(i in 1:20){
  missing_mtcars[sample(1:nrow(mtcars),1),sample(1:ncol(mtcars),1)]<-NA
}
covmat<-covEM(as.matrix(missing_mtcars))$sigma
calpha(covmat)
}
\references{
Beale, E. M. L., & Little, R. J. A.. (1975). Missing Values in Multivariate Analysis. Journal of the Royal Statistical Society. Series B (methodological), 37(1), 129–145.
}
