% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\docType{data}
\name{med.groups}
\alias{med.groups}
\title{Example of medication groups.}
\format{
An object of class \code{character} of length 6.
}
\usage{
med.groups
}
\description{
An example defining 6 medication groups for \code{med.events.ATC}.
It is a \emph{named character vector}, where the names are the medication
group unique \emph{names} (e.g., "Vitamines") and the elements are the medication
group \emph{definitions} (e.g., "(CATEGORY_L2 == 'VITAMINS')").
The definitions are \code{R} logical expressions using \emph{column names} and
\emph{values} that appear in the dataset, as well as references to other
medication groups using the construction \emph{"\{NAME\}"}.
}
\details{
In the above example, "CATEGORY_L2" is a column name in the \code{med.events.ATC}
dataset, and 'VITAMINS' one of its possible values, and which selects all events
that have prescribed ATC codes "A11" (aka "VITAMINS").
Another example is "NotVita" defined as "(!\{Vitamines\})", which selects all
events that do not have Vitamines prescribed.

For more details, please see the acompanying vignette.
}
\keyword{datasets}
