% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_webinars.R
\name{list_webinars}
\alias{list_webinars}
\title{Get List of Webinars for a User.}
\usage{
list_webinars(user_id, account_id, client_id, client_secret)
}
\arguments{
\item{user_id}{Zoom User Id.}

\item{account_id}{Account Id granted by the Zoom developer app.}

\item{client_id}{Client Id granted by the Zoom developer app.}

\item{client_secret}{Client secret granted by the Zoom developer app.}
}
\value{
A data frame with all of the webinars hosted by a specific user.
}
\description{
Get list of webinars for a User. This is used to get the webinar Id's to
pass into other functions.
}
\examples{
\dontrun{
dat <- get_webinar_details(user_id = "user_id_string",
  your_account_id,
  your_client_id,
  your_client_secret)
}
}
\seealso{
See <https://marketplace.zoom.us/docs/api-reference/zoom-api/> for 
documentation on the Zoom API.
}
