% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfit_base_zfunction_zfitter.R
\name{zfitter}
\alias{zfitter}
\title{Create a pipe-friendly version of a given fitting function}
\usage{
zfitter(fun)
}
\arguments{
\item{fun}{The fitting function to adapt. The name should not be quoted,
rather, the actual function should be passed (prefixed with package
if needed)}
}
\description{
This creates a pipe-friendly verion of a fitting function of the
standard format –– that is a function with a \code{formula} parameter
followed by a \code{data} parameter.

Compared to just using \code{zfunction()}, this function includes some special
handling to make the call information, which is usually reported by the
\code{summary()} function more intuitive. Among other things, it shortens very
long data names (longer than 32 characters by default), which otherwise are a
nuisance when the data comes from the pipe, because the pipeline gets
converted to a very long function call.

This function also stores the base name of the original fitting function,
allowing one to use itsfull name, which is useful to just pull a single
fitting function from a package without loading it.
}
\examples{

zlm_robust <- zfitter(estimatr::lm_robust)
zlm_robust(cars, speed~dist)

# The resulting function works well the native pipe ...
if ( getRversion() >= "4.1.0" ) {

  # Pipe cars dataset into zlm_robust for fitting
  cars |> zlm_robust( speed ~ dist )
}

# ... or with dplyr
if ( require("dplyr", warn.conflicts=FALSE) ) {

  # Pipe cars dataset into zlm_robust for fitting
  cars \%>\% zlm_robust( speed ~ dist )

  # Process iris with filter() before piping. Print a summary()
  # of the fitted model using zprint() before assigning the
  # model itself (not the summary) to m
  m <- iris \%>\%
    dplyr::filter(Species=="setosa") \%>\%
    zlm_robust(Sepal.Length ~ Sepal.Width + Petal.Width) \%>\%
    zprint(summary)
}

}
