% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisqtest.R
\name{chisqtest}
\alias{chisqtest}
\title{Chi-squared test}
\usage{
chisqtest(x, p_adjust = "BH")
}
\arguments{
\item{x}{\code{\link[zebu]{lassie}} S3 object.}

\item{p_adjust}{multiple testing correction method.
(see \code{\link[stats]{p.adjust.methods}} for a list of methods).}
}
\value{
\code{chisqtest} returns an S3 object of \link[base]{class}
\code{\link[zebu]{lassie}} and \code{\link[zebu]{chisqtest}}.
Adds the following to the lassie object \code{x}:
\itemize{
\item global_p: global association p-value.
\item local_p: array of local association p-values.
}
}
\description{
Chi-squared test: statistical significance of (global) chi-squared statistic
and (local) chi-squared residuals
}
\examples{

# Calling lassie on cars dataset
las <- lassie(cars, continuous = colnames(cars), measure = "chisq")

# Permutation test using default settings
chisqtest(las)

}
\seealso{
\code{\link[zebu]{lassie}}
}
