#' zebu: Local Association Measures
#'
#' The zebu package implements the estimation of local (and global) association measures: Ducher's Z, pointwise mutual information and normalized pointwise mutual information. The significance of local (and global) association is accessed using p-values estimated by permutations. Finally, using local association subgroup analysis, it identifies if the association between variables is dependent on the value of another variable.
#'
#' @section Functions:
#'
#' \code{\link[zebu]{lassie}} estimates local (and global) association measures: Ducher's Z, pointwise mutual information and normalized pointwise mutual information.
#'
#' \code{\link[zebu]{permtest}} accesses the significance of local (and global) association values using  p-values estimated by permutations.
#'
#' \code{\link[zebu]{subgroups}} identifies if the association between variables is dependent on the value of another variable.
#'
#' @docType package
#' @name zebu
#'
NULL
