% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_ticket_metrics.R
\name{get_all_ticket_metrics}
\alias{get_all_ticket_metrics}
\title{Get Metrics on All Zendesk Tickets}
\usage{
get_all_ticket_metrics(email_id, token, subdomain)
}
\arguments{
\item{email_id}{Zendesk Email Id (username).}

\item{token}{Zendesk API token.}

\item{subdomain}{Your organization's Zendesk sub-domain.}
}
\value{
Data Frame with metrics for all tickets
}
\description{
This function takes your Email Id, authentication token,
sub-domain and parse all the tickets and its corresponding
metrics in a list. Since each iteration only returns 100
tickets at a time you must run the loop until the
"next_page" parameter is equal to null.
}
\details{
Its not a good practice to write down these authentication
parameters in your code. There are various methods and
packages available that are more secure; this package
doesn't require you to use any one in particular.
}
\examples{
\dontrun{
ticket_metrics <- get_all_ticket_metrics(email_id, token, subdomain)
}
}
\references{
\url{https://developer.zendesk.com/rest_api
/docs/support/ticket_metrics}
}
