% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zbeta.R
\name{Zbeta}
\alias{Zbeta}
\title{Runs the Zbeta function}
\usage{
Zbeta(pos, ws, x, minRandL = 4, minRL = 25, X = NULL)
}
\arguments{
\item{pos}{A numeric vector of SNP locations}

\item{ws}{The window size which the \eqn{Z_{\beta}}{Zbeta} statistic will be calculated over. This should be on the same scale as the \code{pos} vector.}

\item{x}{A matrix of SNP values. Columns represent chromosomes; rows are SNP locations. Hence, the number of rows should equal the length of the \code{pos} vector. SNPs should all be biallelic.}

\item{minRandL}{Minimum number of SNPs in each set R and L for the statistic to be calculated. Default is 4.}

\item{minRL}{Minimum value for the product of the set sizes for R and L. Default is 25.}

\item{X}{Optional. Specify a region of the chromosome to calculate \eqn{Z_{\beta}}{Zbeta} for in the format \code{c(startposition, endposition)}. The start position and the end position should be within the extremes of the positions given in the \code{pos} vector. If not supplied, the function will calculate \eqn{Z_{\beta}}{Zbeta} for every SNP in the \code{pos} vector.}
}
\value{
A list containing the SNP positions and the \eqn{Z_{\beta}}{Zbeta} values for those SNPs
}
\description{
Returns a \eqn{Z_{\beta}}{Zbeta} value for each SNP location supplied to the function.
For more information about the \eqn{Z_{\beta}}{Zbeta} statistic, please see Jacobs (2016).
The \eqn{Z_{\beta}}{Zbeta} statistic is defined as:
\deqn{Z_{\beta}=\frac{\sum_{i \in L,j \in R}r^2_{i,j}}{|L||R|}}
where \code{|L|} and \code{|R|} are the number of SNPs to the left and right of the current locus within the given window \code{ws}, and \eqn{r^2}{r^2} is equal to the squared correlation between a pair of SNPs
}
\examples{
## load the snps example dataset
data(snps)
## run Zbeta over all the SNPs with a window size of 3000 bp
Zbeta(snps$bp_positions,3000,as.matrix(snps[,3:12]))
## only return results for SNPs between locations 600 and 1500 bp
Zbeta(snps$bp_positions,3000,as.matrix(snps[,3:12]),X=c(600,1500))

}
\references{
Jacobs, G.S., T.J. Sluckin, and T. Kivisild, \emph{Refining the Use of Linkage Disequilibrium as a Robust Signature of Selective Sweeps.} Genetics, 2016. \strong{203}(4): p. 1807
}
