% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae.R
\name{aeExpectation}
\alias{aeExpectation}
\title{Asymptotic Expansion - Functionals}
\usage{
aeExpectation(f, bounds, ae, eps = 1, order = NULL, ...)
}
\arguments{
\item{f}{character. The functional.}

\item{bounds}{named list of integration bounds in the form \code{list(x = c(xmin, xmax), y = c(ymin, ymax), ...)}}

\item{ae}{an object of class \code{\link{yuima.ae-class}}.}

\item{eps}{numeric. The intensity of the perturbation.}

\item{order}{integer. The expansion order. If \code{NULL} (default), it uses the maximum order used in \code{ae}.}

\item{...}{additional arguments passed to \code{\link[cubature]{cubintegrate}}.}
}
\value{
return value of \code{\link[cubature]{cubintegrate}}. The expectation of the functional provided.
}
\description{
Compute the expected value of functionals.
}
\examples{
\dontrun{
# model
gbm <- setModel(drift = 'mu*x', diffusion = 'sigma*x', solve.variable = 'x')

# settings
xinit <- 100
par <- list(mu = 0.01, sigma = 0.2)
sampling <- setSampling(Initial = 0, Terminal = 1, n = 1000)

# asymptotic expansion
approx <- ae(model = gbm, sampling = sampling, order = 4, true.parameter = par, xinit = xinit)

# compute the mean via integration
aeExpectation(f = 'x', bounds = list(x = c(0,1000)), ae = approx)

# compare with the mean computed by differentiation of the characteristic function
aeMean(approx)
}
}
