% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae.R
\docType{class}
\name{yuima.ae-class}
\alias{yuima.ae-class}
\alias{initialize,yuima.ae-method}
\alias{plot,yuima.ae,ANY-method}
\title{Class for the asymptotic expansion of diffusion processes}

\description{
The \code{yuima.ae} class is used to describe the output of the functions \code{\link{ae}} and \code{\link{aeMarginal}}.
}
\section{Slots}{

\describe{
\item{\code{order}}{integer. The order of the expansion.}

\item{\code{var}}{character. The state variables.}

\item{\code{u.var}}{character. The variables of the characteristic function.}

\item{\code{eps.var}}{character. The perturbation variable.}

\item{\code{characteristic}}{expression. The characteristic function.}

\item{\code{density}}{expression. The probability density function.}

\item{\code{Z0}}{numeric. The solution to the deterministic process obtained by setting the perturbation to zero.}

\item{\code{Mu}}{numeric. The drift vector for the representation of Z1.}

\item{\code{Sigma}}{matrix. The diffusion matrix for the representation of Z1.}

\item{\code{c.gamma}}{list. The coefficients of the Hermite polynomials.}

\item{\code{h.gamma}}{list. Hermite polynomials.}
}}

