% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{decorate}
\alias{decorate}
\title{Decorate a List-like Object}
\usage{
decorate(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}
}
\value{
a list-like object, typically data.frame
}
\description{
Decorates a list-like object. Generic.
See \code{\link{decorate.character}}.
}
\examples{
library(csv)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(as.csv(file))
identical(decorate(as.csv(file)), decorate(file))
decorations(x) # but prefer as_yamlet(x)


}
\seealso{
Other decorate: 
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{decorate.list}()},
\code{\link{decorations.data.frame}()},
\code{\link{decorations}()}

Other interface: 
\code{\link{decorate.character}()},
\code{\link{decorate.list}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_csv}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_table}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()},
\code{\link{io_yamlet}()},
\code{\link{read_yamlet}()},
\code{\link{write_yamlet}()}
}
\concept{decorate}
\concept{interface}
